#delimit ;

/********************************************************************************************
Final data cleaning, labels, save data
********************************************************************************************/

/**************************/
**** Count Observations ****;
/**************************/
egen obs=count(idstd), by(country);

gen m1a = .;
replace m1a = 1 if obst1==100;
replace m1a = 2 if obst2==100;
replace m1a = 3 if obst3==100;
replace m1a = 4 if obst4==100;
replace m1a = 5 if obst5==100;
replace m1a = 6 if obst6==100;
replace m1a = 7 if obst7==100;
replace m1a = 8 if obst8==100;
replace m1a = 9 if obst9==100;
replace m1a = 10 if obst10==100;
replace m1a = 11 if obst11==100;
replace m1a = 12 if obst12==100;
replace m1a = 13 if obst13==100;
replace m1a = 14 if obst14==100;
replace m1a = 15 if obst15==100;


** ------------ from "$global_legacy_dofiles\\add a2_string.do" ------------ ;
** beeps 2009 data ;

* Albania2009;

replace a2_2 = "Durres" if country=="Albania2009" & a2==2;
replace a2_2 = "Elbasan" if country=="Albania2009" & a2==3;
replace a2_2 = "Fier" if country=="Albania2009" & a2==4;
replace a2_2 = "Tirana" if country=="Albania2009" & a2==1;
replace a2_2 = "Vlora" if country=="Albania2009" & a2==5;

* Armenia2009, updated 27 oct 09;
replace a2_2 = "North" if country=="Armenia2009" & a2==4;
replace a2_2 = "South-West" if country=="Armenia2009" & a2==3;
replace a2_2 = "South-East" if country=="Armenia2009" & a2==2;
replace a2_2 = "Yerevan" if country=="Armenia2009" & a2==1;

* Azerbaijan2009;
replace a2_2 = "Aranski & Gorno-Shirvanski" if country=="Azerbaijan2009" & a2==1;
replace a2_2 = "Baku & Apsheronski" if country=="Azerbaijan2009" & a2==2;
replace a2_2 = "Giandja-Kazakhski & Sheki-Zakatalski" if country=="Azerbaijan2009" & a2==3;
replace a2_2 = "Lenkoranski & Kuba-Khachmazski" if country=="Azerbaijan2009" & a2==4;

* Bih2009;
replace a2_2 = "Bosnia Region" if country=="Bosnia and Herzegovina2009" & a2==1;
replace a2_2 = "Herzegovina Region" if country=="Bosnia and Herzegovina2009" & a2==2;
replace a2_2 = "Republika Srpska" if country=="Bosnia and Herzegovina2009" & a2==3;
replace a2_2 = "Sarajevo Region" if country=="Bosnia and Herzegovina2009" & a2==4;

*Bulgaria2009 ;
replace a2_2 = "Severen Tsentralen" if country=="Bulgaria2009" & a2==2;
replace a2_2 = "Severoiztochen" if country=="Bulgaria2009" & a2==3;
replace a2_2 = "Severozapaden" if country=="Bulgaria2009" & a2==1;
replace a2_2 = "Yugoiztochen" if country=="Bulgaria2009" & a2==6;
replace a2_2 = "Yugozapaden" if country=="Bulgaria2009" & a2==4;
replace a2_2 = "Yuzhen Tsentralen" if country=="Bulgaria2009" & a2==5;

*Croatia2009 ;
replace a2_2 = "Dalmatia" if country=="Croatia2009" & a2==6;
replace a2_2 = "Istria, Primorje And Gorski Kotar" if country=="Croatia2009" & a2==5;
replace a2_2 = "Lika And Banovina" if country=="Croatia2009" & a2==4;
replace a2_2 = "Northern Croatia" if country=="Croatia2009" & a2==2;
replace a2_2 = "Slavonia" if country=="Croatia2009" & a2==3;
replace a2_2 = "Zagrebá And Surroundings" if country=="Croatia2009" & a2==1;

* Czech2009;
replace a2_2 = "Middle Bohemia" if country=="Czechia2009" & a2==2;
replace a2_2 = "Middle Morava" if country=="Czechia2009" & a2==7;
replace a2_2 = "Moravskoslezsko" if country=="Czechia2009" & a2==8;
replace a2_2 = "North-East" if country=="Czechia2009" & a2==5;
replace a2_2 = "North-West" if country=="Czechia2009" & a2==4;
replace a2_2 = "Praha" if country=="Czechia2009" & a2==1;
replace a2_2 = "Sourth-East" if country=="Czechia2009" & a2==6;
replace a2_2 = "South-West" if country=="Czechia2009" & a2==3;

* Estonia2009;
replace a2_2 = "Central-Estonia" if country=="Estonia2009" & a2==3;
replace a2_2 = "East-Estonia" if country=="Estonia2009" & a2==4;
replace a2_2 = "North-Estonia" if country=="Estonia2009" & a2==1;
replace a2_2 = "South-Estonia" if country=="Estonia2009" & a2==5;
replace a2_2 = "West-Estonia" if country=="Estonia2009" & a2==2;

* Fyrom2009 ;
replace a2_2 = "Eastern Macedonia Region" if country=="North Macedonia2009" & a2==1;
replace a2_2 = "North-West & West Macedonia Region" if country=="North Macedonia2009" & a2==2;
replace a2_2 = "Skopje Region" if country=="North Macedonia2009" & a2==3;
replace a2_2 = "South Macedonia Region" if country=="North Macedonia2009" & a2==4;

* Georgia2009;
replace a2_2 = "Imereti" if country=="Georgia2008" & a2==5;
replace a2_2 = "Kakheti" if country=="Georgia2008" & a2==3;
replace a2_2 = "Kvemo Kartli" if country=="Georgia2008" & a2==2;
replace a2_2 = "Mmtskheta-Mtianeti" if country=="Georgia2008" & a2==4;
replace a2_2 = "Shida Kartli" if country=="Georgia2008" & a2==6;
replace a2_2 = "Tbilissi" if country=="Georgia2008" & a2==1;

* Hungary2009;
replace a2_2 = "Budapest Central" if country=="Hungary2009" & a2==1;
replace a2_2 = "East Hungary" if country=="Hungary2009" & a2==3;
replace a2_2 = "West Hungary" if country=="Hungary2009" & a2==2;

* Kazakhstan2009;
replace a2_2 = "Center" if country=="Kazakhstan2009" & a2==5;
replace a2_2 = "East" if country=="Kazakhstan2009" & a2==4;
replace a2_2 = "North" if country=="Kazakhstan2009" & a2==1;
replace a2_2 = "South" if country=="Kazakhstan2009" & a2==2;
replace a2_2 = "West" if country=="Kazakhstan2009" & a2==3;

* Kosovo2009; 
replace a2_2 = "Ferizaj" if country=="Kosovo2009" & a2==4;
replace a2_2 = "Gjakove" if country=="Kosovo2009" & a2==7;
replace a2_2 = "Gjilan" if country=="Kosovo2009" & a2==6;
replace a2_2 = "Mitrovice" if country=="Kosovo2009" & a2==5;
replace a2_2 = "Peje" if country=="Kosovo2009" & a2==3;
replace a2_2 = "Prishtine" if country=="Kosovo2009" & a2==1;
replace a2_2 = "Prizren" if country=="Kosovo2009" & a2==2;

* Kyrgyzstan2009 ;
replace a2_2 = "Bishkek" if country=="Kyrgyz Republic2009" & a2==1;
replace a2_2 = "Chui Oblast" if country=="Kyrgyz Republic2009" & a2==2;
replace a2_2 = "Issik Kul Oblast" if country=="Kyrgyz Republic2009" & a2==5;
replace a2_2 = "Jalabad" if country=="Kyrgyz Republic2009" & a2==3;
replace a2_2 = "Osh" if country=="Kyrgyz Republic2009" & a2==4;

* Latvia2009 ;
replace a2_2 = "Kurzeme" if country=="Latvia2009" & a2==3;
replace a2_2 = "Latgale" if country=="Latvia2009" & a2==6;
replace a2_2 = "Pieriga" if country=="Latvia2009" & a2==2;
replace a2_2 = "Riga" if country=="Latvia2009" & a2==1;
replace a2_2 = "Vidzeme" if country=="Latvia2009" & a2==4;
replace a2_2 = "Zemgale" if country=="Latvia2009" & a2==5;

* Lithuania2009 ;
replace a2_2 = "Coast And West" if country=="Lithuania2009" & a2==1;
replace a2_2 = "North East" if country=="Lithuania2009" & a2==2;
replace a2_2 = "South West" if country=="Lithuania2009" & a2==3;
replace a2_2 = "Vilniaus" if country=="Lithuania2009" & a2==4;

* Moldova2009 ;
replace a2_2 = "Centre" if country=="Moldova2009" & a2==3;
replace a2_2 = "North" if country=="Moldova2009" & a2==1;
replace a2_2 = "South" if country=="Moldova2009" & a2==2;
replace a2_2 = "South-East" if country=="Moldova2009" & a2==4;

* Mongolia2009 ;
replace a2_2 = "Central" if country=="Mongolia2009" & a2==2;
replace a2_2 = "East" if country=="Mongolia2009" & a2==1;
replace a2_2 = "Khangai" if country=="Mongolia2009" & a2==3;
replace a2_2 = "Ulaanbaatar Capital City" if country=="Mongolia2009" & a2==5;
replace a2_2 = "West" if country=="Mongolia2009" & a2==4;

* Montenegro2009 ;
replace a2_2 = "Centre And South" if country=="Montenegro2009" & a2==1;
replace a2_2 = "Coast" if country=="Montenegro2009" & a2==2;
replace a2_2 = "North" if country=="Montenegro2009" & a2==3;

* Poland2009; 
replace a2_2 = "Central Region" if country=="Poland2009" & a2==1;
replace a2_2 = "Eastern Region" if country=="Poland2009" & a2==3;
replace a2_2 = "Northern Region" if country=="Poland2009" & a2==6;
replace a2_2 = "North-Western Region" if country=="Poland2009" & a2==4;
replace a2_2 = "Southern Region" if country=="Poland2009" & a2==2;
replace a2_2 = "South-Western Region" if country=="Poland2009" & a2==5;

* Romania2009; 
replace a2_2 = "Bucharest-Ilfov" if country=="Romania2009" & a2==8;
replace a2_2 = "Center" if country=="Romania2009" & a2==7;
replace a2_2 = "North-East" if country=="Romania2009" & a2==1;
replace a2_2 = "North-West" if country=="Romania2009" & a2==6;
replace a2_2 = "South Muntenia" if country=="Romania2009" & a2==3;
replace a2_2 = "South-East" if country=="Romania2009" & a2==2;
replace a2_2 = "South-West Oltenia" if country=="Romania2009" & a2==4;
replace a2_2 = "West" if country=="Romania2009" & a2==5;

* Russia2009; 
replace a2_2 = "Central" if country=="Russia2009" & a2==2;
replace a2_2 = "Far East" if country=="Russia2009" & a2==7;
replace a2_2 = "North-West" if country=="Russia2009" & a2==1;
replace a2_2 = "Siberia" if country=="Russia2009" & a2==5;
replace a2_2 = "South" if country=="Russia2009" & a2==3;
replace a2_2 = "Ural" if country=="Russia2009" & a2==4;
replace a2_2 = "Volga" if country=="Russia2009" & a2==6;

* Serbia2009;
replace a2_2 = "Belgrade" if country=="Serbia2009" & a2==1;
replace a2_2 = "Central Sebia" if country=="Serbia2009" & a2==4;
replace a2_2 = "East Serbia" if country=="Serbia2009" & a2==6;
replace a2_2 = "South Serbia" if country=="Serbia2009" & a2==3;
replace a2_2 = "Vojvodina" if country=="Serbia2009" & a2==2;
replace a2_2 = "West Serbia" if country=="Serbia2009" & a2==5;

* Slovakia2009;
replace a2_2 = "Bratislavsky Kraj" if country=="Slovak Republic2009" & a2==1;
replace a2_2 = "Stredne Slovensko" if country=="Slovak Republic2009" & a2==2;
replace a2_2 = "Vychodne Slovensko" if country=="Slovak Republic2009" & a2==3;
replace a2_2 = "Zapadne Slovensko" if country=="Slovak Republic2009" & a2==4;

* Slovenia2009;
replace a2_2 = "Vzhodna Slovenija" if country=="Slovenia2009" & a2==1;
replace a2_2 = "Zahodna Slovenija" if country=="Slovenia2009" & a2==2;


**SAR ;
***  Afghanistan 09 ;
replace a2_2 ="Kabul" if country=="Afghanistan2009" & a2==1;
replace a2_2 ="Hirat" if country=="Afghanistan2009" & a2==2;
replace a2_2 ="Kandahar" if country=="Afghanistan2009" & a2==3;
replace a2_2 ="Mazar" if country=="Afghanistan2009" & a2==4;
replace a2_2 ="Jalalabad" if country=="Afghanistan2009" & a2==5;
replace a2_2 ="Bamyan, Ghazni, Khost, Kunduz, Pul-e-khumri" if country=="Afghanistan2009" & a2==6;


**Congo2009;
replace a2_2 ="Brazzaville" if country=="Congo2009" & a2==1;
replace a2_2 ="Pointe-Noire" if country=="Congo2009" & a2==2;

** Cotedivoire2009;
replace a2_2 ="Abidjan" if country=="CÃ´te d'Ivoire2009" & a2==1;
replace a2_2 ="San-pédro" if country=="CÃ´te d'Ivoire2009" & a2==2;
replace a2_2 ="Yamoussoukro" if country=="CÃ´te d'Ivoire2009" & a2==3;

**Gabon2009;
replace a2_2 ="Libreville" if country=="Gabon2009" & a2==1;
replace a2_2 ="Owendo" if country=="Gabon2009" & a2==2;
replace a2_2 ="Port-Gentil" if country=="Gabon2009" & a2==3;


**Lesotho2009;
replace a2_2 ="Maseru" if country=="Lesotho2009" & a2==1;

**Liberia2009;
replace a2_2 ="Montserrado" if country=="Liberia2009" & a2==1;
replace a2_2 ="Margibi" if country=="Liberia2009" & a2==2;
replace a2_2 ="Nimba" if country=="Liberia2009" & a2==3;

**Madagascar2009;
replace a2_2 ="Antananarivo" if country=="Madagascar2009" & a2==1;
replace a2_2 ="Mahajanga" if country=="Madagascar2009" & a2==2;
replace a2_2 ="Toamasina" if country=="Madagascar2009" & a2==3;
replace a2_2 ="Antsiranana" if country=="Madagascar2009" & a2==4;

** Mauritius2009;
replace a2_2 ="Port louis" if country=="Mauritius2009" & a2==1;
replace a2_2 ="Nord" if country=="Mauritius2009" & a2==2;
replace a2_2 ="Est" if country=="Mauritius2009" & a2==3;
replace a2_2 ="Ouest" if country=="Mauritius2009" & a2==4;
replace a2_2 ="Centre" if country=="Mauritius2009" & a2==5;
replace a2_2 ="Sud" if country=="Mauritius2009" & a2==6;


**Sierra Leone2009;
replace a2_2 ="Free town" if country=="Sierra Leone2009" & a2==1;
replace a2_2 ="Kenema" if country=="Sierra Leone2009" & a2==2;

** ------------ end of add a2_string.do ------------ ;
ren region_WB region;
encode country,gen(countryx);

local out2 "reg1 bus2 bus3 bus1 reg9 reg10 reg11 bus5 reg8 reg12 reg7 reg6 reg2 reg2_c tax1 tax2 tax3 tax4 tax5 tax6 tax7 tax8 reg4 reg5 fin23 fin24 fin25 fin15 fin14 fin11 fin10 fin26 fin20 fin27 fin21 fin12 fin1 fin2 fin3 fin4 fin5 fin13 fin22 fin6 fin7 fin8 fin9 fin19 t2 fin28 fin29 fin30 fin31 fin32 fin16 fin33 fin17 fin18 in16 in2 in3 in3_c in15 in4 in4_c in9 in10 in10_c in1 in12 in17 in18 in6 in19 in20 in7 in7_c in5 in21 in22 in14 in11 in23 in24 in25 in26 gend1 gend6 gend4 gend7 gend2 gend5 gend3 gend8 gend9 tr10 tr15 tr17 tr16 tr5 tr6 tr4 tr1 tr18 tr18_u tr19 tr20 tr12 tr13 tr11 tr21 tr8 tr22 tr7 tr2 tr23 tr24 tr24_u tr25 tr9 tr26 comp1 comp2 comp3 comp4 comp5 comp6 comp7 comp8 comp9 graft3 graft2  graft1 corr1 corr2 corr3 corr10 corr9 corr8 corr6 corr7 corr4 corr11 infor1 infor4 infor5 infor2 disp1 disp2 disp3 disp4 disp5 crime9 disp6 corr12 wk1 wk2 wk8 wk20 wk14 wk21 wk11 wk12 wk3 wk4 wk6 wk7 wk18 wk22 wk17 wk15 wk16 wk19 wk23 wk13 wk24 wk25 wk26 wk27 wk9 wk28 wk10 mgmt1 mgmt2 mgmt3 mgmt4 mgmt5 mgmt6 mgmt7 mgmt8 mgmt9 t7 t7_ml t8 t9 t9_ml t10 t11 t1 t4 t5 perf1 perf2 perf3 perf4 t3 car1 car7 car8  car2 car3 car4 car5 car6 lform3 lform lform_max lform1 lform2 lform4 lform5 lform6 obst1 obst2 obst3 obst4 obst5 obst6 obst7 obst8 obst9 obst10 obst11 obst12 obst13 obst14 obst15 crime1 crime10 crime3 crime3_c crime2 crime2_c crime5 crime8"      ; /** added by Nona on June 26, 2024 **/;
keep country2 country_official ccode fyear  n3_l2_year d2_l1_year_perf_indicators n3_l2_year_perf_indicators  d2_n3_last_month_fy_perf_ind sector_3 a2_2 isic isic_v4 m1a country_abr a0 s idstd wbcode countryx country obs year region sector sector2 d1a2 d1a2_v4 ownership exporter size wt wt_6_followups wt_5a_followups wt_5b_followups wt_5c_followups wt_4a_followups wt_4b_followups a3* a2 a2_2 strata `out2' graftsum tgraft egraft wgraft cgraft igraft ograft reg2_c crime2_c crime3_c in3_c in4_c in7_c in10_c sme usefin1 usefin2 usefin3 usefin4 usefin5 usefin6 stra_sector sector_MS deflator_adjust_d2 exrate_d2 deflator_adjust_n3 exrate_n3 unitconverter;

rename a2_2 a2x;
replace a3ax = a2x if a3ax== "";

sort country;

*--13. add number of regions based on a2x-------------------------;
bysort country a2x: gen ch = _N if _n==_N & a2x~="";
bysort country: egen nregion2=count(ch);
replace nregion2=. if nregion2==0;
la var nregion2 "Number of subnational regions";
ren nregion nregionold;
*ren nregion2 nregion;

*--1. create IS (Indicator Survey) dummy -------------------------;
gen ISdummy = 0;
replace ISdummy =1 if a0==6;
replace ISdummy =1 if country=="Fiji2009" | country=="Vanuatu2009";

*----------------------------------------------
*-- ADD latest country/year survey dummy  --
*----------------------------------------------;
gen ctry = substr(country,1,length(country)-4);
egen latest = max(year), by(ctry);  
gen sample = 1 if year == latest ;
replace sample = 0 if sample == .;
drop ctry latest;
	

sort country;
#delimit cr
 /**** $global_legacy_dofiles\\a3ax_labcorrect.do  added 10-12-11 by Dave ****/
 /**************************************************************************
*            DO FILE TO CORRECT LABELS FOR a3ax                           *
*             based on excel sheet found here:                            *
*   O:\FPDEA\web standardization\Label_correct\correcting regions.xlsx    *
*        Written:10-6-11; last update:10-26-11                             *
**************************************************************************/

replace a3ax="Cordoba" if a3ax=="C�Rdoba" & country=="Argentina2010"
replace a3ax="Entire country" if a3ax=="Region A" & country=="Bahamas2010"
replace a3ax="Bosnia" if a3ax=="Bosnia Region" & country=="Bosnia and Herzegovina2009"
replace a3ax="Herzegovina" if a3ax=="Herzegovina Region" & country=="Bosnia and Herzegovina2009"
replace a3ax="Republic of Serbia" if a3ax=="Republika Srpska" & country=="Bosnia and Herzegovina2009"
replace a3ax="Sarajevo" if a3ax=="Sarajevo Region" & country=="Bosnia and Herzegovina2009"
replace a3ax="Rio Grande do Sul" if a3ax=="Rio Grande Do Sul" & country=="Brazil2003"
replace a3ax="Cear�" if a3ax=="Ceará" & country=="Brazil2009"
replace a3ax="Brasilia DF" if a3ax=="Distrito Federal" & country=="Brazil2009"
replace a3ax="Goias" if a3ax=="Goi�S" & country=="Brazil2009"
replace a3ax="Maranhao" if a3ax=="Maranh�O" & country=="Brazil2009"
replace a3ax="Parana" if a3ax=="Paran�" & country=="Brazil2009"
replace a3ax="Paraiba" if a3ax=="Para�Ba" & country=="Brazil2009"
replace a3ax="Rio de Janeiro" if a3ax=="Rio De Janeiro" & country=="Brazil2009"
replace a3ax="Rio Grande do Sul" if a3ax=="Rio Grande Do Sul" & country=="Brazil2009"
replace a3ax="Sao Paulo" if a3ax=="S�O Paulo" & country=="Brazil2009"
replace a3ax="Bobo-Dioulasso" if a3ax=="Bobo Diaulasso" & country=="Burkina Faso2009"
replace a3ax="Ouagadougou" if a3ax=="Ouagadogou" & country=="Burkina Faso2009"
replace a3ax="West" if a3ax=="Bafousam" & country=="Cameroon2009"
replace a3ax="Coastal" if a3ax=="Douala" & country=="Cameroon2009"
replace a3ax="Central" if a3ax=="Yaounde" & country=="Cameroon2009"
replace a3ax="N'Djamena" if a3ax=="Ndjamena" & country=="Chad2009"
replace a3ax="Antofagasta" if a3ax=="Ii Regi�N (Antofasgstata)" & country=="Chile2010"
replace a3ax="Santiago" if a3ax=="Rm (Santiago)" & country=="Chile2010"
replace a3ax="Valparaiso" if a3ax=="V Regi�N (Valpara�So)" & country=="Chile2010"
replace a3ax="Los Lagos" if a3ax=="X Regi�N (Los Lagos)" & country=="Chile2010"
replace a3ax="Bogota" if a3ax=="Bogot� " & country=="Colombia2010"
replace a3ax="Medellin" if a3ax=="Medell�N" & country=="Colombia2010"
replace a3ax="Rest of the country" if a3ax=="Rest Of The Country" & country=="Costa Rica2010"
replace a3ax="San Jose" if a3ax=="San Jos� De Costa Rica" & country=="Costa Rica2010"
replace a3ax="San Pedro" if a3ax=="San-PéDro" & country=="CÃ´te d'Ivoire2009"
replace a3ax="Central Bohemia" if a3ax=="Middle Bohemia" & country=="Czechia2009" //updated by Andrea on 3/18/2020
replace a3ax="Central Moravia" if a3ax=="Middle Morava" & country=="Czechia2009" //updated by Andrea on 3/18/2020
replace a3ax="Moravia Silesia" if a3ax=="Moravskoslezsko" & country=="Czechia2009" //updated by Andrea on 3/18/2020
replace a3ax="Northeast" if a3ax=="North-East" & country=="Czechia2009" //updated by Andrea on 3/18/2020
replace a3ax="Northwest" if a3ax=="North-West" & country=="Czechia2009" //updated by Andrea on 3/18/2020
replace a3ax="Prague" if a3ax=="Praha" & country=="Czechia2009" //updated by Andrea on 3/18/2020
replace a3ax="Southeast" if a3ax=="Sourth-East" & country=="Czechia2009" //updated by Andrea on 3/18/2020
replace a3ax="Southwest" if a3ax=="South-West" & country=="Czechia2009" //updated by Andrea on 3/18/2020
replace a3ax="Rest of the country" if a3ax=="Rest Of The Country" & country=="El Salvador2010"
replace a3ax="Debub" if a3ax=="Daebub" & country=="Eritrea2009"
replace a3ax="Central" if a3ax=="Central- Estonia" & country=="Estonia2009"
replace a3ax="East" if a3ax=="East-Estonia" & country=="Estonia2009"
replace a3ax="North" if a3ax=="North-Estonia" & country=="Estonia2009"
replace a3ax="South" if a3ax=="South-Estonia" & country=="Estonia2009"
replace a3ax="West" if a3ax=="West -Estonia" & country=="Estonia2009"
replace a3ax="Fiji" if a3ax=="Lautoka" & country=="Fiji2009"
replace a3ax="Fiji" if a3ax=="Nadi" & country=="Fiji2009"
replace a3ax="Fiji" if a3ax=="Suva" & country=="Fiji2009"
replace a3ax="Eastern Macedonia" if a3ax=="Eastern Macedonia Region" & country=="North Macedonia2009"
replace a3ax="North-West & West Macedonia" if a3ax=="North-West & West Macedonia Region" & country=="North Macedonia2009"
replace a3ax="Skopje" if a3ax=="Skopje Region" & country=="North Macedonia2009"
replace a3ax="South Macedonia" if a3ax=="South Macedonia Region" & country=="North Macedonia2009"
replace a3ax="Entire country" if a3ax=="Region A" & country=="Grenada2010"
replace a3ax="Guatemala City" if a3ax=="Ciudad De Guatemala" & country=="Guatemala2010"
replace a3ax="Rest of the country" if a3ax=="Rest Of The Country" & country=="Guatemala2010"
replace a3ax="Entire country" if a3ax=="Region A" & country=="Guyana2010"
replace a3ax="Rest of the country" if a3ax=="Rest Of The Country" & country=="Honduras2010"
replace a3ax="West" if a3ax=="West Hungary" & country=="Hungary2009"
replace a3ax="DKI Jakarta" if a3ax=="Dki Jakarta" & country=="Indonesia2009"
replace a3ax="Kingston" if a3ax=="Region A" & country=="Jamaica2010"
replace a3ax="Rest of the country" if a3ax=="Region B" & country=="Jamaica2010"
replace a3ax="Central" if a3ax=="Center" & country=="Kazakhstan2009"
replace a3ax="Urosevac" if a3ax=="Ferizaj" & country=="Kosovo2009"
replace a3ax="Dakovica" if a3ax=="Gjakove" & country=="Kosovo2009"
replace a3ax="Gnjilane" if a3ax=="Gjilan" & country=="Kosovo2009"
replace a3ax="Kosovska Mitrovica" if a3ax=="Mitrovice" & country=="Kosovo2009"
replace a3ax="Pec" if a3ax=="Peje" & country=="Kosovo2009"
replace a3ax="Pristina" if a3ax=="Prishtine" & country=="Kosovo2009"
replace a3ax="Issyk-Kul Oblast" if a3ax=="Issik Kul Oblast" & country=="Kyrgyz Republic2009"
replace a3ax="Jalalabad" if a3ax=="Jalabad" & country=="Kyrgyz Republic2009"
replace a3ax="Osh Oblast" if a3ax=="Osh" & country=="Kyrgyz Republic2009"
replace a3ax="Vientiane" if a3ax=="Vientiane Capital" & country=="Laos2009"
replace a3ax="Coast and West" if a3ax=="Coast And West" & country=="Lithuania2009"
replace a3ax="North" if a3ax=="Northern" & country=="Malawi2009"
replace a3ax="South" if a3ax=="Southern" & country=="Malawi2009"
replace a3ax="Central" if a3ax=="Centre" & country=="Mauritius2009"
replace a3ax="East" if a3ax=="Est" & country=="Mauritius2009"
replace a3ax="North" if a3ax=="Nord" & country=="Mauritius2009"
replace a3ax="West" if a3ax=="Ouest" & country=="Mauritius2009"
replace a3ax="South" if a3ax=="Sud" & country=="Mauritius2009"
replace a3ax="Estado de Mexico" if a3ax=="Amcm" & country=="Mexico2010"
replace a3ax="Mexico DF" if a3ax=="Distrito Federal" & country=="Mexico2010"
replace a3ax="Jalisco" if a3ax=="Guadalajara" & country=="Mexico2010"
replace a3ax="Guanajuato" if a3ax=="Le�N" & country=="Mexico2010"
replace a3ax="Coahuila" if a3ax=="Monclova" & country=="Mexico2010"
replace a3ax="Nuevo Leon" if a3ax=="Monterrey" & country=="Mexico2010"
replace a3ax="Central" if a3ax=="Centre" & country=="Moldova2009"
replace a3ax="Southeast" if a3ax=="South-East" & country=="Moldova2009"
replace a3ax="Ulaanbaatar" if a3ax=="Ulaanbaatar Capital City" & country=="Mongolia2009"
replace a3ax="Central and South" if a3ax=="Centre And South" & country=="Montenegro2009"
replace a3ax="Rest of the country" if a3ax=="Rest Of The Country" & country=="Nicaragua2010"
replace a3ax="Panama City" if a3ax=="Ciudad De Panam�" & country=="Panama2010"
replace a3ax="Rest of the country" if a3ax=="Rest Of The Country" & country=="Panama2010"
replace a3ax="Asuncion" if a3ax=="Asunci�N" & country=="Paraguay2010"
replace a3ax="NCR Excluding Manila" if a3ax=="National Capital Region (Excl: Manila)" & country=="Philippines2009"
replace a3ax="Central" if a3ax=="Central Region" & country=="Poland2009"
replace a3ax="Eastern" if a3ax=="Eastern Region" & country=="Poland2009"
replace a3ax="Northwest" if a3ax=="North-Western Region" & country=="Poland2009"
replace a3ax="North" if a3ax=="Northern Region" & country=="Poland2009"
replace a3ax="Southwest" if a3ax=="South-Western Region" & country=="Poland2009"
replace a3ax="South" if a3ax=="Southern Region" & country=="Poland2009"
replace a3ax="Bucharest" if a3ax=="Bucharest-Ilfov" & country=="Romania2009"
replace a3ax="Northeast" if a3ax=="North-East" & country=="Romania2009"
replace a3ax="Northwest" if a3ax=="North-West" & country=="Romania2009"
replace a3ax="Southeast" if a3ax=="South-East" & country=="Romania2009"
replace a3ax="Southwest Oltenia" if a3ax=="South-West Oltenia" & country=="Romania2009"
replace a3ax="Volgo-Viatsky" if a3ax=="Volga" & country=="Russia2009"
replace a3ax="Central" if a3ax=="Central Sebia" & country=="Serbia2009"
replace a3ax="East" if a3ax=="East Serbia" & country=="Serbia2009"
replace a3ax="South" if a3ax=="South Serbia" & country=="Serbia2009"
replace a3ax="Vojvodina" if a3ax=="Vojvodina" & country=="Serbia2009"
replace a3ax="West" if a3ax=="West Serbia" & country=="Serbia2009"
replace a3ax="Freetown" if a3ax=="Free Town" & country=="SierraLeone2009"
replace a3ax="Bratislava" if a3ax=="Bratislavsky Kraj" & country=="Slovak Republic2009"
replace a3ax="Efate " if a3ax=="Tongatapu" & country=="Vanuatu2009"
replace a3ax="Al Hudaydah" if a3ax=="Al Hudaida" & country=="Yemen2010"
replace a3ax="Al Mukalla" if a3ax=="Mukala" & country=="Yemen2010"
replace a3ax="Sanaa" if a3ax=="Sana�A" & country=="Yemen2010"
replace a3ax="Rest of the country" if a3ax=="Rest Of The Country" & country=="Dominican Republic2010"
replace a3ax="Rest of the country" if a3ax=="Rest Of The Country" & country=="Jamaica2010"
replace a3ax="Rest of the country" if a3ax=="Rest Of The Country" & country=="Trinidad and Tobago2010"


// added by Nona on December 4, 2019 to fix unicode issues
replace a3ax="Cordoba" if strpos(a3ax,"Rdoba")>0& country=="Argentina2010"
replace a3ax="Ceara" if strpos(a3ax,"Cear")>0& country=="Brazil2009"
replace a3ax="Goias" if strpos(a3ax,"Goi")>0& country=="Brazil2009"
replace a3ax="Maranhao" if strpos(a3ax,"Maranh")>0& country=="Brazil2009"
replace a3ax="Paraiba" if strpos(a3ax,"Para")>0 & strpos(a3ax,"Ba")& country=="Brazil2009"
replace a3ax="Parana" if strpos(a3ax,"Paran")>0& country=="Brazil2009"
replace a3ax="Sao Paulo" if strpos(a3ax,"O Paulo")>0& country=="Brazil2009"
replace a3ax="Antofagasta" if strpos(a3ax,"(Antofasgstata)")>0& country=="Chile2010"
replace a3ax="Valparaiso" if strpos(a3ax,"N (Valpara")>0& country=="Chile2010"
replace a3ax="Los Lagos" if strpos(a3ax,"N (Los Lagos)")>0& country=="Chile2010"
replace a3ax="Bogota" if strpos(a3ax,"Bogot")>0& country=="Colombia2010"
replace a3ax="Medellin" if strpos(a3ax,"Medell")>0& country=="Colombia2010"
replace a3ax="San Jose" if strpos(a3ax,"San Jos")>0& country=="Costa Rica2010"
replace a3ax="San Pedro" if strpos(a3ax,"San-P")>0& country=="Cote d'Ivoire2009"
replace a3ax="Guanajuato" if strpos(a3ax,"Le")>0&strlen(a3ax)==4& country=="Mexico2010"
replace a3ax="Panama City" if strpos(a3ax,"Ciudad De Panam")>0& country=="Panama2010"
replace a3ax="Asuncion" if strpos(a3ax,"Asunci")>0& country=="Paraguay2010"
replace a3ax="Sanaa" if strpos(a3ax,"Sana")>0& country=="Yemen2010"

replace a3ax = "Thiès" if country == "Senegal2014" & strpos(a3ax,"Thi")>0 // added by Nona on June 28, 2024 to fix special character error
replace a3ax = "Vientiane" if country=="Lao PDR2009" & a3ax == "Vientiane Capital" // added by Ziqiao on Sep 16, 2024
replace a3ax = "Lome" if country == "Togo2009" & a3ax == "lome" // added by Ziqiao on Sep 16, 2024 to fix capitalization character error
replace a3ax = "Niamey" if country == "Niger2009" & a3ax == "niamey" // added by Ziqiao on Sep 16, 2024 to fix capitalization character error
replace a3ax = "Maradi" if country == "Niger2009" & a3ax == "maradi" // added by Ziqiao on Sep 16, 2024 to fix capitalization character error
replace a3ax = "ŠUmadija And Western Serbia" if country == "Serbia2013" & strpos(a3ax,"Umadija And Western Serbia")>0 // added by Ziqiao on Sep 16, 2024 to fix special character error
replace a3ax = "ÐAkovica" if country == "Kosovo2013" & strpos(a3ax,"kovica")>0
replace a3ax = "Kosovska Mitrovica/Mitrovicë" if country == "Kosovo2013" & strpos(a3ax,"Kosovska Mitrovica")>0
replace a3ax = "Pec/Pejë" if country == "Kosovo2013" & strpos(a3ax,"Pec/Pej")>0
replace a3ax = "Linköping, Örebro, Karlstad, Västerås" if country == "Sweden2014" & strpos(a3ax,"Karlstad")>0
replace a3ax = "Malmö-Lund" if country == "Sweden2014" & strpos(a3ax,"Lund")>0
replace a3ax = "Borås, Göteborg, Jönköping, Trollhättan" if country == "Sweden2014" & strpos(a3ax,"Troll")>0

#delimit ;
rename isic isic_v3_1;
rename s size_num ; // added by Nona on April 25, 2017 as per agreements with Asif, Josh and Andrea;
rename n3_l2_year fyear_n3_l2;

drop nregionold sme tgraft egraft wgraft cgraft igraft ograft graftsum usefin1 usefin2 usefin3 usefin4 usefin5 usefin6 ch sector2 sector;
*added sector2 and sector by Nona on January 19, 2018;
*removed graft1b regfpct by Nona on June 26, 2024;

/***********************************************  *****************/
************************ Add/modify labels ************************;
/***********************************************  *****************/

/**************** Recode Ownership Exporter *************************/
recode ownership (2=0) (1=100);
label define ownership 0 "Domestic" 100 "Foreign";
label value ownership ownership;

recode exporter (2=0) (1=100);
label define exporter 0 "Non-exporter" 100 "Exporter";
label value exporter exporter;

/**************** Add labels *************************/
label variable obst1 "Access to Finance";
label variable obst2 "Access to Land";
label variable obst3 "Licenses & Permits";
label variable obst4 "Corruption";
label variable obst5 "Courts";
label variable obst6 "Crime, Theft & Disorder";
label variable obst7 "Customs & Trade Reg";
label variable obst8 "Electricity";
label variable obst9 "Inadequately educated workforce";
label variable obst10 "Labor regulations";
label variable obst11 "Political instability";
label variable obst12 "Practices Informal Sector";
label variable obst13 "Tax Administration";
label variable obst14 "Tax Rates";
label variable obst15 "Transportation";

cap label drop m1a;
la def m1a 
1 "1-Access to finance"	
2 "2-Access to land"
3 "3-Business licensing and permits"
4 "4-Corruption"
5 "5-Courts"
6 "6-Crime, theft and disorder"
7 "7-Customs and trade regulations"
8 "8-Electricity"
9 "9-Inadequately educated workforce"
10 "10-Labor regulations"
11 "11-Political instability"
12 "12-Practices of competitors in the informal sector"
13 "13-Tax administration"
14 "14-Tax rates"
15 "15-Transport" ;
la val m1a m1a;

#delimit cr
label var fyear_n3_l2 "Fiscal year for n3 and l2"
label var unitconverter "multiplier for numerical variables for consistency with the current LCU"

label var size_num "Size"
label var wbcode "Economy code"
label var d1a2 "Main Product/Service ISIC (Rev. 3.1) Code"
*label var a3a "Region Of The Establishment"
label var a3ax "Sampling Region, string"
label var stra_sector "Sector based on d1a2, grouped as per stratification sector"
label var fyear "Fiscal year"
label var sector_MS "Sector: Manufacturing or Services"
label var isic_v3_1 "ISIC code (Rev. 3.1)"
label var isic_v4 "ISIC code (Rev. 4.0)"
label var m1a "Biggest Obstacle"
label var sample "Dummy equal 1 for the latest survey in each economy"
label var ISdummy "Dummy equal 1 for indicator surveys"
label var graft1 "Graft index"

label var countryx  "Economy" // added on Feb. 17, 2024 by Nona
label var ccode "ISO Economy code 3166-1 Numeric" // added on Feb. 17, 2024 by Nona

label variable a0  "Questionnaire type"
label variable idstd  "WEB STD firm id"
label var country   "Economy"
label variable country_official "World Bank's offical economy"
label var obs "Number of observations per economy"
label variable year  "Year of survey"
label variable sector_3  "Manufacturing, Retail, Other Services classification"
label variable region  "Region "
// label variable income  "Income group"
label variable ownership  "Ownership type (foreign vs. domestic)"
label variable exporter  "Exporter (exporters vs. non exporters)"
label variable size  "Size (small, medium and large)"

label variable wt  "Sampling weight"
label variable wt_6_followups  "Sampling weight, vars in 6 follow-ups in 2023 rollout: BGD IRQ MDG PER TLS IDN"
label variable wt_5a_followups "Sampling weight, vars in 5 follow-ups in 2023 rollout: BGD IRQ MDG PER IDN"
label variable wt_5b_followups "Sampling weight, vars in 5 follow-ups in 2023 rollout: BGD IRQ MDG PER TLS"
label variable wt_5c_followups "Sampling weight, vars in 5 follow-ups in 2023 rollout: BGD IRQ MDG TLS IDN"
label variable wt_4a_followups  "Sampling weight, vars in 4 follow-ups in 2023 rollout: BGD IRQ MDG TLS"
label variable wt_4b_followups  "Sampling weight, vars in 4 follow-ups in 2023 rollout: BGD IRQ MDG IDN"

label variable a2  "Economy sampling region"
label variable a2x  "Economy sampling region - string"
label variable strata  "Strata"

label variable country_abr "Economy abbreviation"
label variable country2 "Economy name (no year suffix)"
label variable d2_l1_year_perf_indicators "The year that corresponds to d2 and l1 and is used for the purposes of calculating perf1 and perf3 indicators"  // added by Nona on August 24, 2016
label variable n3_l2_year_perf_indicators "The year that corresponds to n3 and l2 and is used for the purposes of calculating perf1 and perf3 indicators"  // added by Nona on August 24, 2016
label variable d2_n3_last_month_fy_perf_ind "The last month of fiscal year, used for the purposes of calculating perf1 and perf3 indicator" // added by Nona on June 12, 2017

label var reg1 "Senior management time spent dealing with the requirements of government regulation (%)"
label var bus2 "Days to obtain an operating license"
label var bus3 "[B-READY] Days to obtain a construction-related permit [median]"
label var bus1 "Days to obtain an import license"
label var reg9 "[B-READY] Days to receive payment under government contract"
label var reg10 "[B-READY] Percent of firms visited or inspected for health or safety"
label var reg11 "[B-READY] Percent of firms with a report issued for health or safety inspection"
label var bus5 "Percent of firms identifying business licensing and permits as a major or very severe constraint"
label var reg8 "Percent of firms identifying access to land as a major or very severe constraint"
label var reg12 "[B-READY] Perceptions index of access to land as a constraint"
label var reg7 "Percent of firms identifying political instability as a major or very severe constraint"
label var reg6 "Percent of firms visited or required to meet with tax officials"
label var reg2 "Number of visits or required meetings with tax officials"
label var reg2_c "If there were visits, average number of visits or required meetings with tax officials"
label var tax1 "[B-READY] Hours spent on tax compliance annually [median]"
label var tax2 "[B-READY] Percent of firms filing taxes electronically"
label var tax3 "[B-READY] Percent of firms paying taxes electronically"
label var tax4 "[B-READY] Weeks until the final tax audit report [median]"
label var tax5 "[B-READY] Weeks to receive VAT refund [median]"
label var tax6 "[B-READY] Percent of firms reporting too long or complicated refund process as the main reason for not applying for a VAT refund, among those providing a reason other than no need"
label var tax7 "[B-READY] Reported share of social security and employment-based taxes in annual cost of labor"
label var tax8 "[B-READY] Reported effective income-based tax rate"
label var reg4 "Percent of firms identifying tax rates as a major or very severe constraint"
label var reg5 "Percent of firms identifying tax administration as a major or very severe constraint"
label var fin23 "Percent of firms that are fully credit constrained"
label var fin24 "Percent of firms that are partially credit constrained"
label var fin25 "Percent of firms that are credit unconstrained"
label var fin15 "Percent of firms with a checking or savings account"
label var fin14 "Percent of firms with a bank loan/line of credit"
label var fin11 "Proportion of loans requiring collateral (%)"
label var fin10 "Value of collateral needed for a loan (% of the loan amount)"
label var fin26 "[B-READY] Percent of firms reporting unfavorable rates, collateral, or procedures as main reason for not applying for loans"
label var fin20 "Percent of firms not needing a loan"
label var fin27 "[B-READY] Days to receive a decision on loan application"
label var fin21 "Percent of firms whose recent loan application was rejected"
label var fin12 "Percent of firms using banks to finance investments"
label var fin1 "Proportion of investment financed internally (%)"
label var fin2 "Proportion of investment financed by banks (%)"
label var fin3 "Proportion of investment financed by supplier/customer credit (%)"
label var fin4 "Proportion of investment financed by equity or stock sales (%)"
label var fin5 "Proportion of investment financed by other financing (%)"
label var fin13 "Percent of firms using banks to finance working capital"
label var fin22 "Percent of firms using supplier/customer credit to finance working capital"
label var fin6 "Proportion of working capital financed internally (%)"
label var fin7 "Proportion of working capital financed by banks (%)"
label var fin8 "Proportion of working capital financed  by supplier/customer credit (%)"
label var fin9 "Proportion of working capital financed by other financing (%)"
label var fin19 "Working Capital External Financing (%)"
label var t2 "Percent of firms with an annual financial statement reviewed by external auditors"
label var fin28 "[B-READY] Proportion of sales paid by customers electronically"
label var fin29 "[B-READY] Days to receive the main type of electronic payment "
label var fin30 "[B-READY] Cost to receive main type of electronic payment (% of transaction)"
label var fin31 "[B-READY] Proportion of payments made electronically"
label var fin32 "[B-READY] Cost to make main type of electronic payment (% of transaction)"
label var fin16 "Percent of firms identifying access to finance as a major or very severe constraint"
label var fin33 "[B-READY] Perceptions index of access to finance as a constraint"
label var fin17 "Proportion of sales that are pre-paid (%)"
label var fin18 "Proportion of sales sold on credit (%)"
label var in16 "Percent of firms experiencing electrical outages"
label var in2 "[B-READY] Number of electrical outages in a typical month"
label var in3 "[B-READY] Duration, in hours, of a typical electrical outage [median]"
label var in3_c "If there were outages, average duration in hours of a typical electrical outage"
label var in15 "Average total time of power outages per month"
label var in4 "[B-READY] Losses due to electrical outages (% of annual sales) [median]"
label var in4_c "If there were outages, average losses due to electrical outages (% of annual sales)"
label var in9 "[B-READY] Percent of firms owning or sharing  a generator"
label var in10 "Proportion of electricity from a generator (%)"
label var in10_c "If a generator is used, average proportion of electricity from a generator (%)"
label var in1 "[B-READY] Days to obtain an electrical connection, upon application [median]"
label var in12 "Percent of firms identifying electricity as a major or very severe constraint"
label var in17 "Percent of firms experiencing water insufficiencies*"
label var in18 "[B-READY] Percent of firms experiencing water insufficiencies"
label var in6 "Number of water insufficiencies in a typical month*"
label var in19 "Number of water insufficiencies in a typical month"
label var in20 "Duration, in hours, of a typical water shortage"
label var in7 "Duration, in hours, of insufficient water supplies*"
label var in7_c "If there were shortages, Average Duration in hours of the Water Shortage*"
label var in5 "[B-READY] Days to obtain a water connection [median]"
label var in21 "[B-READY] Percent of firms experiencing internet disruptions"
label var in22 "[B-READY] Days to obtain internet connection [median]"
label var in14 "Proportion of products lost to breakage or spoilage during shipping to domestic markets (%)*"
label var in11 "Percent of firms identifying transportation as a major or very severe constraint"
label var in23 "[B-READY] Perceptions index of transportation as a constraint"
label var in24 "Percent of firms experiencing damage of physical assets due to extreme weather"
label var in25 "Percent of firms monitoring own CO2 emissions over last 3 years"
label var in26 "Percent of firms adopting energy management measures to reduce emissions over last 3 years"
label var gend1 "Percent of firms with women participation in ownership"
label var gend6 "Percent of firms with majority women ownership"
label var gend4 "Percent of firms with a woman top manager"
label var gend7 "[B-READY] Percent of firms owned or managed by women among those that held a government contract in last 3 years"
label var gend2 "Proportion of permanent full-time workers that are women (%)"
label var gend5 "Proportion of permanent full-time production workers that are women (%)*"
label var gend3 "Proportion of permanent full-time non-production workers that are women (%)*"
label var gend8 "Proportion of women workers offered formal training over last fiscal year (%)*"
label var gend9 "Proportion of women workers offered formal training over last fiscal year (%, only service sector)"
label var tr10 "Percent of firms exporting directly or indirectly at least 1% of sales"
label var tr15 "Percent of firms exporting directly at least 1% of sales"
label var tr17 "Percent of firms exporting directly or indirectly at least 10% of sales"
label var tr16 "Percent of firms exporting directly at least 10% of sales"
label var tr5 "Proportion of total sales that are exported directly (%)"
label var tr6 "Proportion of total sales that are exported indirectly (%)"
label var tr4 "Proportion of total sales that are domestic sales (%)"
label var tr1 "Days to clear direct exports through customs*"
label var tr18 "[B-READY] Days for exported goods to clear all border control agencies [median]"
label var tr18_u "Days for all exported goods to clear all border control agencies"
label var tr19 "[B-READY] Percent of firms that export at least some products via parcel service"
label var tr20 "[B-READY] Typical costs to comply with all export requirements (% of value of goods exported)"
label var tr12 "Products exported directly lost due to theft (%)"
label var tr13 "Products exported directly lost due to breakage or spoilage (%)"
label var tr11 "Percent of firms using material inputs and/or supplies of foreign origin*"
label var tr21 "Percent of firms using material inputs and/or supplies of foreign origin"
label var tr8 "Proportion of total inputs that are of foreign origin (%)*"
label var tr22 "Proportion of total inputs that are of foreign origin (%)"
label var tr7 "Proportion of total inputs that are of domestic origin (%)*"
label var tr2 "Days to clear imports from customs*"
label var tr23 "Days to clear imports from customs"
label var tr24 "[B-READY] Days for imported goods to clear all border control agencies [median] "
label var tr24_u "Days for all imported goods to clear all border control agencies"
label var tr25 "[B-READY] Typical costs to comply with all import requirements (% of value of goods imported)"
label var tr9 "Percent of firms identifying customs and trade regulations as a major or very severe constraint"
label var tr26 "[B-READY] Perceptions index of customs and trade regulations as a constraint"
label var comp1 "[B-READY] Index of market share of the largest competitor (excluding firms whose main market is international)"
label var comp2 "[B-READY] Percent of firms reporting less than two competitors in their main product's main market (excluding firms whose main market is international)"
label var comp3 "[B-READY] Percent of firms reporting between two and five (inclusive) competitors in their main product's main market (excluding firms whose main market is international)"
label var comp4 "[B-READY] Percent of firms reporting more than five competitors in their main product's main market (excluding firms whose main market is international)"
label var comp5 "[B-READY] Percent of firms that cannot increase prices more than competitors without losing customers"
label var comp6 "[B-READY] Percent of firms reporting their prices to be regulated"
label var comp7 "[B-READY] Index of change of level of competition over last year"
label var comp8 "[B-READY] Index of difficulty to switch internet providers"
label var comp9 "[B-READY] Perceptions of the degree of difficulty to comply with government contract tender requirements"
label var graft3 "Bribery incidence (percent of firms experiencing at least one bribe payment request)"
label var graft2  "Bribery depth (% of public transactions where a gift or informal payment was requested)"
label var graft1 "Graft index"
label var corr1 "Percent of firms expected to give gifts in meetings with tax officials"
label var corr2 "Percent of firms expected to give gifts to secure government contract"
label var corr3 "Value of gift expected to secure a government contract (% of contract value)"
label var corr10 "Percent of firms expected to give gifts to get an operating license"
label var corr9 "Percent of firms expected to give gifts to get an import license "
label var corr8 "Percent of firms expected to give gifts to get a construction permit"
label var corr6 "Percent of firms expected to give gifts to get an electrical connection"
label var corr7 "Percent of firms expected to give gifts to get a water connection"
label var corr4 "Percent of firms expected to give gifts to public officials to get things done"
label var corr11 "Percent of firms identifying corruption as a major or very severe constraint"
label var infor1 "Percent of firms competing against unregistered or informal firms"
label var infor4 "Percent of firms formally registered when they started operations"
label var infor5 "Number of years firm operated without formal registration"
label var infor2 "Percent of firms identifying practices of competitors in the informal sector as a major or very severe constraint                  "
label var disp1 "Percent of firms that had any commercial dispute"
label var disp2 "Percent of firms that use courts, arbitration, mediation, or conciliation to resolve or attempt to resolve its commercial disputes"
label var disp3 "[B-READY] Perceptions of courts being independent and impartial in resolving commercial disputes"
label var disp4 "[B-READY] Perceptions of arbitration being a reliable alternative to courts for resolving commercial disputes"
label var disp5 "[B-READY] Perceptions of mediation being a reliable alternative to courts for resolving commercial disputes"
label var crime9 "Percent of firms identifying the courts as a major or very severe constraint                         "
label var disp6 "[B-READY] Perceptions index of courts as a constraint"
label var corr12 "Percent of firms believing the court system is fair, impartial and uncorrupted"
label var wk1 "[B-READY] Percent of firms offering formal training over last fiscal year"
label var wk2 "Proportion of workers offered formal training over last fiscal year (%)*"
label var wk8 "Years of the top manager's experience working in the firm's sector"
label var wk20 "Percent of firms where the largest owner is also the top manager"
label var wk14 "Number of workers"
label var wk21 "Number of permanent full-time equivalent workers"
label var wk11 "Number of temporary workers"
label var wk12 "Number of permanent full-time workers"
label var wk3 "Number of permanent skilled production workers*"
label var wk4 "Number of permanent unskilled production workers*"
label var wk6 "Number of permanent production workers*"
label var wk7 "Number of permanent non-production workers*"
label var wk18 "Proportion of permanent workers, out of all workers"
label var wk22 "Proportion of permanent workers, out of all permanent full-time equivalent workers"
label var wk17 "Proportion of temporary workers out of all workers"
label var wk15 "Proportion of production workers, out of all permanent workers*"
label var wk16 "Proportion of non-production workers out of all permanent workers*"
label var wk19 "Proportion of skilled workers, out of all permanent production workers (%)*"
label var wk23 "Proportion of permanent full time workers that completed high school"
label var wk13 "Proportion of unskilled workers out of all permanent production workers (%)*"
label var wk24 "[B-READY] Weeks to dismiss a full-time permanent worker"
label var wk25 "[B-READY] Weeks paid in severance "
label var wk26 "[B-READY] Percent of firms involved in labor dispute over last 3 years"
label var wk27 "[B-READY] Months to resolve labor dispute"
label var wk9 "Percent of firms identifying labor regulations as a major or very severe constraint"
label var wk28 "[B-READY] Perceptions index of labor regulations as a constraint"
label var wk10 "Percent of firms identifying an inadequately educated workforce as a major or very severe constraint"
label var mgmt1 "Management practices index"
label var mgmt2 "Score on action when a problem arose"
label var mgmt3 "Score on number of performance indicators monitored"
label var mgmt4 "Score on time focus of production/service provision targets"
label var mgmt5 "Score on achievability of production/service provision targets"
label var mgmt6 "Score on knowledge of production/service provision targets"
label var mgmt7 "Score on basis of managers' performance bonuses"
label var mgmt8 "Score on extent to which non-managers are promoted based on performance"
label var mgmt9 "Score on extent to which under-performing non-managers are reassigned or dismissed"
label var t7 "Percent of firms that introduced a new product/service over last 3 years"
label var t7_ml "Percent of medium or large firms that introduced a new product/service over last 3 years"
label var t8 "Percent of firms whose new product/service is also new to the main market"
label var t9 "Percent of firms that introduced a process innovation over last 3 years"
label var t9_ml "Percent of medium or large firms that introduced a process innovation over last 3 years"
label var t10 "Percent of firms that spend on R&D in the last fiscal years"
label var t11 "[B-READY] Percent of firms that introduced a new product/service and process over last 3 years, and spent on R&D over last fiscal year (excluding small firms)"
label var t1 "[B-READY] Percent of firms with an internationally-recognized quality certification"
label var t4 "Percent of firms using technology licensed from foreign companies*"
label var t5 "Percent of firms having their own web site"
label var perf1 "Real annual sales growth (%)"
label var perf2 "Annual employment growth (%)"
label var perf3 "Real annual labor productivity growth (%)"
label var perf4 "Percent of firms buying fixed assets"
label var t3 "Capacity utilization (%)*"
label var car1 "Age of the establishment (years)"
label var car7 "Percent of firms with at least 10% of foreign ownership"
label var car8  "Percent of firms with at least 10% of government/state ownership"
label var car2 "Proportion of private domestic ownership in a firm (%)"
label var car3 "Proportion of private foreign ownership in a firm (%)"
label var car4 "Proportion of government/state ownership in a firm (%)"
label var car5 "Proportion of other ownership in a firm (%)"
label var car6 "Proportion of a firm held by the largest owner(s) (%)"
label var lform3 "Percent of firms with legal status of Sole Proprietorship"
label var lform "Legal status"
label var lform_max "Most common legal form"
label var lform1 "Percent of firms with legal status of publicly listed company"
label var lform2 "Percent of firms with legal status of privately held Limited Liability Company"
label var lform4 "Percent of firms with legal status of Partnership"
label var lform5 "Percent of firms with legal status of Limited Partnership"
label var lform6 "Legal status - Other"
label var obst1 "Percent of firms choosing access to finance as their biggest obstacle"
label var obst2 "Percent of firms choosing access to land as their biggest obstacle"
label var obst3 "Percent of firms choosing business licensing and permits as their biggest obstacle"
label var obst4 "Percent of firms choosing corruption as their biggest obstacle"
label var obst5 "Percent of firms choosing courts as their biggest obstacle"
label var obst6 "Percent of firms choosing crime, theft and disorder as their biggest obstacle"
label var obst7 "Percent of firms choosing customs and trade regulations as their biggest obstacle"
label var obst8 "Percent of firms choosing electricity as their biggest obstacle"
label var obst9 "Percent of firms choosing inadequately educated workforce as their biggest obstacle"
label var obst10 "Percent of firms choosing labor regulations as their biggest obstacle"
label var obst11 "Percent of firms choosing political instability as their biggest obstacle"
label var obst12 "Percent of firms choosing practices of the informal sector as their biggest obstacle"
label var obst13 "Percent of firms choosing tax administration as their biggest obstacle"
label var obst14 "Percent of firms choosing tax rates as their biggest obstacle"
label var obst15 "Percent of firms choosing transportation as their biggest obstacle"
label var crime1 "Percent of firms paying for security"
label var crime10 "Percent of firms experiencing losses due to theft and vandalism"
label var crime3 "Losses due to theft and vandalism against the firm (% of annual sales)"
label var crime3_c "If there were losses, average losses due to theft and vandalism (% of annual sales)"
label var crime2 "Security costs (% of annual sales)"
label var crime2_c "If the establishment pays for security, average security costs (% of annual sales)"
label var crime5 "Products shipped to supply domestic markets that were lost due to theft (% of product value)*"
label var crime8 "Percent of firms identifying crime, theft and disorder as a major or very severe constraint"
label var region "WB Region Classification"


#delimit ;
drop ISdummy a0 ;

order sample	a2	idstd	country	country2	country_abr	countryx	country_official	ccode	wbcode	year	fyear	fyear_n3_l2	region	a2x	a3ax	strata	size	size_num	obs	ownership	exporter	isic_v3_1	isic_v4	d1a2	d1a2_v4	stra_sector	sector_3	sector_MS	d2_l1_year_perf_indicators	n3_l2_year_perf_indicators	d2_n3_last_month_fy_perf_ind	unitconverter	exrate_d2	exrate_n3	deflator_adjust_d2	deflator_adjust_n3	wt	wt_5c_followups	wt_4a_followups	wt_4b_followups	wt_6_followups	wt_5a_followups	wt_5b_followups	perf1	perf2	perf3	perf4	corr1	corr2	corr3	corr4	corr6	corr7	corr8	corr9	corr10	corr11	corr12	graft1	graft2	graft3	reg1	reg2	reg2_c	reg4	reg5	reg6	reg7	reg8	reg9	reg10	reg11	reg12	bus1	bus2	bus3	bus5	crime1	crime2	crime2_c	crime3	crime3_c	crime5	crime8	crime9	crime10	infor1	infor2	infor4	infor5	gend1	gend2	gend3	gend4	gend5	gend6	gend7	gend8	gend9	fin1	fin2	fin3	fin4	fin5	fin6	fin7	fin8	fin9	fin10	fin11	fin12	fin13	fin14	fin15	fin16	fin17	fin18	fin19	fin20	fin21	fin22	fin23	fin24	fin25	fin26	fin27	fin28	fin29	fin30	fin31	fin32	fin33	in1	in2	in3	in3_c	in4_c	in4	in5	in6	in7	in7_c	in9	in10	in10_c	in11	in12	in14	in15	in16	in17	in18	in19	in20	in21	in22	in23	in24	in25	in26	t1	t2	t3	t4	t5	t7	t8	t9	t10	t11	tr1	tr2	tr4	tr5	tr6	tr7	tr8	tr9	tr10	tr11	tr12	tr13	tr15	tr16	tr17	tr18	tr19	tr20	tr21	tr22	tr23	tr24	tr25	tr26	wk1	wk2	wk3	wk4	wk6	wk7	wk8	wk9	wk10	wk11	wk12	wk13	wk14	wk15	wk16	wk17	wk18	wk19	wk20	wk21	wk22	wk23	wk24	wk25	wk26	wk27	wk28	car1	car2	car3	car7	car4	car8	car5	car6	lform	lform1	lform2	lform3	lform4	lform5	lform6	lform_max	mgmt2	mgmt3	mgmt4	mgmt5	mgmt6	mgmt7	mgmt8	mgmt9	mgmt1	tax1	tax2	tax3	tax4	tax5	tax6	tax7	tax8	comp1	comp2	comp3	comp4	comp5	comp6	comp7	comp8	comp9	disp1	disp2	disp3	disp4	disp5	disp6	m1a	obst1	obst2	obst3	obst4	obst5	obst6	obst7	obst8	obst9	obst10	obst11	obst12	obst13	obst14	obst15;

save "$global_outputs\\ES-Indicators-Database-Global-Methodology.dta", replace;

erase "$global_outputs\\in_MAIN input for indicators_.xlsx";
erase "$global_outputs\\PanelDetail.dta";
erase "$global_outputs\\deflation.dta";
erase "$global_outputs\\fieldwork.dta";