#delimit;

/********************************************************************************************
Generate Other Indicators
********************************************************************************************/
gen  reg1=j2;
gen  reg2=j4; replace reg2=0 if j3==2;  
gen  reg2_c=j4 if j4!=0; /** added by Minh 10 Nov 09, per Josh's indicator excel **/;
gen  reg4=100 if j30a==3 | j30a==4;replace reg4=0 if j30a==0 | j30a==1 | j30a==2;
gen  reg5=100 if j30b==3 | j30b==4;replace reg5=0 if j30b==0 | j30b==1 | j30b==2;
gen  reg6=100 if j3==1|(j3==-8|j3==.a); replace reg6=0 if j3==2; /** added by Nona on May 1, 2017 **/;
gen  reg7=100 if j30e==3 | j30e==4;replace reg7=0 if j30e==0 | j30e==1 | j30e==2; /** added by Nona on August 2, 2017 **/;
gen  reg8=100 if g30a==3 | g30a==4;replace reg8=0 if g30a==0 | g30a==1 | g30a==2; /** added by Nona on August 2, 2017 **/;
gen  bus1=j11;
gen  bus2=j14;
gen  bus3=g3;
for var bus1 bus2 bus3: replace X=. if X>730;
for var bus1 bus2 bus3: replace X=. if X<0.1;
gen  bus5=100  if j30c==3 | j30c==4;replace bus5=0 if j30c==0 | j30c==1 | j30c==2;
gen  corr11=100 if j30f==3 | j30f==4;replace corr11=0 if j30f==0 | j30f==1 | j30f==2;
gen  corr3=j6;
gen  corr12=h7a;recode corr12 (1/2=0) (3/4=100);
gen  crime1=100 if i1==1;replace crime1=0 if  i1==2;

replace i2a=(i2b/d2)*100 if d2~=0 & i2a==.&i2b~=.;gen  crime2=i2a;replace crime2=. if crime2>100; replace crime2=0 if  i1==2;  replace crime2=round(crime2, 0.05); 
                                                  gen  crime2_c=i2a;replace crime2_c=. if crime2_c>100; replace crime2_c=. if  i1==2 & year>=2008 & year~=.; /** added by Minh 10 Nov 09, per Josh's indicator excel **/;   replace crime2_c=round(crime2_c, 0.05); 

replace i4a=(i4b/d2)*100 if d2~=0 & i4a==.&i4b~=. ;   gen  crime3=i4a;replace crime3=. if crime3>100;  replace crime3=0 if  i3==2;  replace crime3=round(crime3, 0.05);
						      gen  crime3_c=i4a;replace crime3_c=. if crime3_c>100;  replace crime3_c=. if  i3==2 & year>=2008 & year~=.; /** added by Minh 10 Nov 09, per Josh's indicator excel **/;  replace crime3_c=round(crime3_c, 0.05); 

gen  crime5=d10 if sector_MS=="Manufacturing"&country!="Venezuela2006"; /*** a0==6 added by josh wimpey 7-2-2009 ***/; /*amended a0==4 for IS manuf by Dave francis 10-3-11*/;

gen  crime10=100 if i3==1;replace crime10=0 if  i3==2;/*** added new indicator by Asif Jan 22, 2014 per Jorge request ***/;


gen  fin17=k2a;
gen  fin18=k2c;
gen  crime8=100 if i30==3|i30==4;replace crime8=0 if i30==0 |i30==1|i30==2;
gen  crime9=100 if h30==3|h30==4;replace crime9=0 if h30==0 |h30==1|h30==2;
gen  infor3=100 if j8>=0&j8<100;replace infor3=0 if j8==100;
gen  infor1=100 if e11==1;replace infor1=0 if  e11==2;
gen  infor2=100 if e30==3|e30==4;replace infor2=0 if e30==0 |e30==1|e30==2;
gen  infor4=100 if b6a==1;replace infor4=0 if  b6a==2;
gen  infor5=(b6b-b5) if b6b>0&b6b!=.;replace infor5=. if  infor5<0;
replace infor5=0 if infor5==.&b6a==1;
gen infor6=infor5; replace infor6=. if b6a!=2;  /*** Added 8-21-2009 by Josh Wimpey ***/;

gen  gend1=100 if b4==1;replace gend1=0 if  b4==2;
drop tsu;
egen tsu=rowtotal(l5a l5b), missing;
gen  gend2=(tsu/l1)*100 if (sector_MS=="Manufacturing" & country!="Venezuela2006"); /*| country=="Cambodia2006"*/; /*** a0==6 added by josh wimpey 7-2-2009 ***/;
replace gend2=. if (l5a==.& l5b==.) & country!="Ethiopia2006";
replace gend2=l5 if (gend2==0 | gend2==.) & country=="Ethiopia2006";
replace gend2=(l5/l1)*100 if gend2==.& country!="Ethiopia2006";    /***** this line added by Josh Wimpey on 6-25-2009 ******/;
replace gend2=. if gend2>100; drop tsu; /* replace gend2=round(gend2, 0.5); turned off by Nona on May 10, 2024 after consultation with Jorge */;
gen  gend3=(l5b/l3b)*100 if (sector_MS=="Manufacturing" & country!="Venezuela2006");  /*Correction made on Jan.30.2014 Xie*/; /*| country=="Cambodia2006"*/; /*** a0==6 added by josh wimpey 7-2-2009 ***/;
replace gend3=. if gend3>100; /* replace gend3=round(gend3,0.5); turned off by Nona on May 10, 2024 after consultation with Jorge */;

gen  gend4=100 if b7a==1;replace gend4=0 if  b7a==2;  /***** gend4  Firms with female top manager---added 6-17-2009 by Josh Wimpey ****/;

gen  gend5=(l5a/l3a)*100 if (sector_MS=="Manufacturing" & country!="Venezuela2006");  /*Added on Jan.30.2014 Xie*/; /*| country=="Cambodia2006"*/; /*** a0==6 added by josh wimpey 7-2-2009 ***/;
replace gend5=. if gend5>100; /* replace gend5=round(gend5,0.5); turned off by Nona on May 10, 2024 after consultation with Jorge */;

gen gend6=100 if b4a>=51 & b4a!=.;   /*Added on July.21.2015 Xie*/;
replace gend6=0 if b4a<=50|b4==2;
sort country;
by country: egen flag=mean(b4a);
replace gend6=. if flag==.;
drop flag;

local var `"Angola2010 Benin2009 Botswana2010 "Burkina Faso2009" "Cabo Verde2009" Cameroon2009 "Central African Republic2011" Chad2009 DRC2010 Congo2009 "Cote d'Ivoire2009" Eritrea2009 Ethiopia2011 Gabon2009 Lesotho2009 Liberia2009 Madagascar2009 Malawi2009 Mali2010 Mauritius2009 Niger2009 Rwanda2011 "Sierra Leone2009" Togo2009"';
foreach cty in `var' {;
  replace gend6=100 if (b3a==3|b3a==4) & country=="`cty'";
  replace gend6=0 if (b3a!=.&gend6==.) & country=="`cty'";
  };

gen  fin1=k5a if k5a != .c; // .c part added on June 15, 2023 by Nona to allow credit constraint handling of negatives ;
gen  fin2=k5bc if k5bc != .c; // .c part added on June 15, 2023 by Nona to allow credit constraint handling of negatives ;
gen  fin3=k5f if k5f != .c; // .c part added on June 15, 2023 by Nona to allow credit constraint handling of negatives ;
gen  fin4=k5i if k5i != .c; // .c part added on June 15, 2023 by Nona to allow credit constraint handling of negatives ;
replace fin4=0 if country=="Syria2009";   /** added Minh 20 July 10 **/;

egen fin5=rowtotal(k5e k5j k5hd), missing;
egen tsu1 = rowtotal(k5e k5hdj), missing; replace fin5 = tsu1 if tsu1>=fin5 & tsu1!=.; drop tsu1; /** added Minh 20 July 09 *** Updated October 28 2011, JW** **/;

egen tsu1 = rowtotal(k5e nk5hdj nk5k), missing; replace fin5 = tsu1 if country=="Nepal2009"; drop tsu1; /** added Minh 21 Aug 09 **/;

/** added other for ECA 4 Feb 2011 **/;
replace fin5= k5hdej if fin5==.;

gen  fin6=k3a if k3a != .c; // .c part added on June 15, 2023 by Nona to allow credit constraint handling of negatives ;

gen  fin7=k3bc if k3bc != .c; // .c part added on June 15, 2023 by Nona to allow credit constraint handling of negatives ;
gen  fin8=k3f if k3f != .c; // .c part added on June 15, 2023 by Nona to allow credit constraint handling of negatives ;
egen  fin9=rowtotal(k3hd k3e), missing;
egen tsu=rowtotal(nk3hd k3e nk3i), missing; 
replace fin9=tsu if country=="Nepal2009"; 
drop tsu;
	
gen  fin10=k15; replace fin10=. if k15>=1000 ; replace fin10=. if k13==2; replace fin10=. if k8==2;

gen  fin11=100 if k13==1;replace fin11=0 if k13==2; replace fin11=. if k8==2;

gen  fin12=100 if (k5bc>0 & k5bc~=. & k5bc~=.c); replace fin12=0 if (k5bc==0) ; // .c part added on June 15, 2023 by Nona to allow credit constraint handling of negatives ;
gen  fin13=100 if (k3bc>0 & k3bc~=.& k3bc~=.c); replace fin13=0 if (k3bc==0) ; // .c part added on June 15, 2023 by Nona to allow credit constraint handling of negatives ;
gen  fin22=100 if (k3f>0 & k3f~=.& k3f~=.c); replace fin22=0 if (k3f==0) ; /** added by Nona on May 1, 2017 **/; // .c part added on June 15, 2023 by Nona to allow credit constraint handling of negatives ;
gen  fin14=100 if k8==1;replace fin14=0 if k8==2;
gen  fin15=100 if k6==1;replace fin15=0 if  k6==2;
gen  fin16=100 if k30==3|k30==4;replace fin16=0 if k30==0 |k30==1|k30==2;
gen  fin20=100 if k17==1; replace fin20=0 if ((k17!=.&k17!=1&k17!=.c)|k16==1); /** added by Judy 4/18/12, amended 5/2/12**/; // .c part added on June 15, 2023 by Nona to allow credit constraint handling of negatives ;
gen  fin21=100 if k20a==2; replace fin21=0 if k20a==1; /** added by Judy 4/18/12**/;


replace fin21=100 if k20a1==3; replace fin21=0 if k20a1==1 | k20a1==2; /*added by Xie 11/5/13  clear it with Asif and Josh/;


** use financing **/;
gen sme = (size==1|size==2) & size~=.;
egen usefin1 = rowtotal(fin12 fin13 fin14), missing; /** do this to avoid missing in all 3 variables by Minh 17 Nov 09**/;
recode usefin1 (200=100) (300=100); /** do this to avoid missing in all 3 variables by Minh 17 Nov 09**/;
egen usefin2 = rowtotal(fin12 fin13), missing; /** do this to avoid missing in all 3 variables by Minh 17 Nov 09**/;
recode usefin2 (200=100); /** do this to avoid missing in all 3 variables by Minh 17 Nov 09**/;

** no external financing - new investment **;
egen temp = rowtotal(k5a k5i), missing; /** added by Minh 18 Nov 09**/;
gen usefin3=100 if temp==100; replace usefin3=0 if temp<100 & temp~=.;
drop temp;
** no external financing - working capital **;
gen usefin4=100 if k3a==100; replace usefin4=0 if k3a<100 & k3a~=.; /** added by Minh 18 Nov 09**/;

** trade credit **; 
egen usefin5=rowtotal(fin3 fin8), missing; /** added by Minh 23 Nov 09**/;
replace usefin5=100 if usefin5>0 & usefin5~=.; /** added by Minh 23 Nov 09**/;

** External financing **;  /** added by Minh 23 Nov 09**/;
gen tsu1=100 if (k5e>0 & k5e~=.); replace tsu1 = 0 if k5e==0;
gen tsu2=100 if (k3e>0 & k3e~=.); replace tsu2 = 0 if k3e==0;
egen usefin6 = rowtotal(fin2 fin7 fin3 fin8 tsu1 tsu2), missing;
replace usefin6=100 if usefin6>0 & usefin6~=.;

** final cleaning of fin indicators from new3, Ziqiao ** ;
egen tsu=rsum(fin1  fin2  fin3  fin4  fin5); gen test=1 if tsu!=100&tsu!=0;
for var fin1  fin2  fin3  fin4  fin5: replace X=. if test==1;
for var fin1-fin5: replace X=. if tsu==0; for var fin1-fin5: replace X=0 if X==.&tsu==100; drop test tsu;
egen tsu=rsum(fin6  fin7  fin8  fin9); gen test=1 if tsu!=100&tsu!=0; for var fin6  fin7  fin8  fin9: replace X=. if test==1;
for var fin6-fin9: replace X=. if tsu==0; for var fin6-fin9: replace X=0 if X==.&tsu==100; drop test tsu;
replace fin4=. if country=="Syria2009";

egen fin19 = rowtotal(fin7 fin8 fin9), missing;

gen  in3=c8; replace in3=0 if c7==0 | c6==2; /** added by Minh 10 Nov 09, per Josh's indicator excel **/;  /** | c6==2 Command added by Josh W April 3 2012**/; 
gen  in3_c=c8; /** added by Minh 10 Nov 09, per Josh's indicator excel **/;

gen  in1=c4;
gen  in2=c7;
replace in2=0 if c6==2;  /** Command added by Josh W April 3 2012**/;
replace in2 = . if in2>150 & in3 > 24 & country=="Congo2009"; /*** replace in2=. if.... added by Minh 7-6-2009 ***/;

gen in16=100 if c6==1; replace in16=0 if c6==2; /** added by Nona on May 1, 2017 **/;

/* replace c9a=(c9b/d2)*100 if d2~=0 & c9a==. & c9b~=.; moved by Nona on May 10, 2024, to just before the outlier routine, after consultation with Jorge */;

gen  in4=c9a;replace in4=. if in4>100; /* replace in4=round(in4, 0.5); turned off by Nona on May 10, 2024 after consultation with Jorge */;
rename in4 in4_c;  /** Command added by Josh W April 3 2012  in4 was conditional. ****/;

/** Command added by Josh W April 3 2012  in4 was conditional.  A new unconditional var is created below**/;
gen in4=.; // edited by Nona on April 30, 2024 to correct imputation of 0 ;
replace in4=in4_c if in4_c!=.;
replace in4=0 if c6==2; // added by Nona on April 30, 2024 to correct imputation of 0 ;
replace in4=. if c6==.;

gen  in5=c13;
gen  in6=c16 if sector_MS=="Manufacturing"; /*** a0==6 added by josh wimpey 7-2-2009 ***/; /*amended a0==4 for IS manuf by Dave francis 10-3-11*/;
replace in6=0 if  sector_MS=="Manufacturing" & c15==2;  /** Command added by Josh W April 3 2012**/;

gen in17=100 if  sector_MS=="Manufacturing" & c15==1; replace in17=0 if  sector_MS=="Manufacturing" & c15==2 ;  /** added by Nona on May 1, 2017 **/; 

gen  in7_c=c17 if sector_MS=="Manufacturing"; /*** a0==6 added by josh wimpey 7-2-2009 ***/; /*amended a0==4 for IS manuf by Dave francis 10-3-11*/;
/** added by Minh 10 Nov 09, per Josh's indicator excel **/;
gen  in7=c17 if sector_MS=="Manufacturing"; replace in7=0 if c16==0 & sector_MS=="Manufacturing"; ;
replace in7=0 if in6==0 & sector_MS=="Manufacturing";  /** Command added by Josh W April 3 2012**/;

**** in7 is not able to more than 728 hours/months, added by Minh 7 July 2009, moved by Ziqiao from new3 ****;
replace in7=. if in7 > 728 & in7~=. ;
replace in7_c=. if in7_c > 728 & in7_c~=. ;

gen  in8=c20;
for var in1 in5 in8: replace X=. if X>730;
for var in1 in5 in8: replace X=. if X<0.1;
gen  in9=100 if c10==1;replace in9=0 if c10==2;


gen  in10_c=c11; /*** sector conditions removed by Asif 6-18-2014 **/; 
gen  in10=c11; replace in10=0 if c10==2; /*** sector conditions removed by Asif 6-18-2014 **/;


gen  in11=100 if d30a==3|d30a==4;replace in11=0 if d30a==0 |d30a==1|d30a==2;
gen  in12=100 if c30a==3|c30a==4;replace in12=0 if c30a==0 |c30a==1|c30a==2;
gen  in14=d11 if sector_MS=="Manufacturing"; /*** a0==6 added by josh wimpey 7-2-2009 ***/; /*amended a0==4 for IS manuf by Dave francis 10-3-11*/;
gen  in15=in2*in3; replace in15=720 if in15>720 & in15!=.;  /***added 720 boundary as number of hours in a month--Josh Wimpey 8-20-2009 *****/;
gen  t1=100 if b8==1;replace t1=0 if b8==2;
gen  t2=100 if k21==1;replace t2=0 if k21==2;
gen  t3=f1 if sector_MS=="Manufacturing"; /*** a0==6 added by josh wimpey 7-2-2009 ***/; /*amended a0==4 for IS manuf by Dave francis 10-3-11*/;

gen  t4=100 if e6==1 & sector_MS=="Manufacturing";replace t4=0 if e6==2 & sector_MS=="Manufacturing"; /*** AI 4-29-2014 e6 just recently got available for services questionnaire, we may change this in the future to apply to all sectors**/; 
gen  t5=100 if c22b==1;replace t5=0 if c22b==2;
gen  t6=100 if c22a==1;replace t6=0 if c22a==2;

gen  t7=100 if h1==1; replace t7=0 if h1==2; /** added by Nona on May 1, 2017 **/;
gen t7_ml=t7 if inlist(size,2,3); // added by Nona on Sept. 18, 2025;

gen  t8=100 if h2==1 & h1==1; replace t8=0 if h2==2 & h1==1; /** added by Nona on May 1, 2017 **/;
gen  t9=100 if h5==1; replace t9=0 if h5==2; /** added by Nona on May 1, 2017 **/;
gen t9_ml=t9 if inlist(size,2,3); // added by Nona on Sept. 18, 2025;

gen  t10=100 if h8==1; replace t10=0 if h8==2; /** added by Nona on May 1, 2017 **/; replace t10 = . if size == 1; /** added by Nona on Jan 20, 2023, cut-off 20+ employees **/

gen  tr1=d4 if sector_MS=="Manufacturing"; // condition added on July 20, 2023 by Nona, applies to global methodology only;
gen  tr2=d14 if sector_MS=="Manufacturing"; /*** a0==6 added by josh wimpey 7-2-2009 ***/; /*amended a0==4 for IS manuf by Dave francis 10-3-11*/;
gen  tr4=d3a;
gen  tr5=d3c ;
gen  tr6=d3b;
gen  tr7=d12a if sector_MS=="Manufacturing"; /*** a0==6 added by josh wimpey 7-2-2009 ***/; /*amended a0==4 for IS manuf by Dave francis 10-3-11*/;
gen  tr8=d12b if sector_MS=="Manufacturing"; /*** a0==6 added by josh wimpey 7-2-2009 ***/; /*amended a0==4 for IS manuf by Dave francis 10-3-11*/;
gen  tr14=d16 if sector_MS=="Manufacturing"; /*** AI 4-29-2014 added manf ***/
gen  tr9=100 if d30b  ==3|d30b  ==4;replace tr9=0 if d30b ==0 |d30b ==1|d30b ==2;
gen  tr10=100 if (d3b>0 & d3b~=.) | (d3c>0 & d3c~=.);replace tr10=0 if d3b==0&d3c==0;

/** the next two lines added by Nona on May 1, 2017 **/;
gen  d3b_mod = d3b if d3b>=0; gen  d3c_mod = d3c if d3c>=0; egen  tr17_temp=rsum(d3b_mod d3c_mod) if (d3b>=0 & d3b~=.) | (d3c>=0 & d3c~=.);
gen  tr17=100 if tr17_temp>=10 & tr17_temp~=.; replace tr17 = 0 if tr17_temp<10; drop d3b_mod d3c_mod tr17_temp;

gen  tr11=100 if (d12b>0 & d12b~=.) & sector_MS=="Manufacturing" ; replace tr11=0 if d12b==0 & sector_MS=="Manufacturing" & country!="Venezuela2006";  /*** a0==6 added by josh wimpey 7-2-2009 ***/;
replace tr11=. if country=="Syria2009" | country=="Lebanon2009" ;  

gen  tr12=d6;
gen  tr13=d7;
egen d3ab=rowtotal(d3a d3b);
gen  tr15=100 if d3c>0 & d3c!=.; replace tr15=0 if d3c==0; replace tr15=0 if d3a==100; replace tr15=0 if d3b==100; replace tr15=0 if d3ab==100; /*** added by josh wimpey 7-29-2009 ***/;
gen  tr16=100 if d3c>=10 & d3c!=.; replace tr16=0 if d3c<10 & d3c>=0; replace tr16=0 if d3a>90&d3a!=.; replace tr16=0 if d3b>90&d3b!=.; replace tr16=0 if d3ab>90&d3ab!=.; /** added by Nona on May 1, 2017 **/;

** final cleaning of fin indicators from new3, Ziqiao ** ;
egen tsu=rsum(tr4 tr5 tr6); gen test=1 if tsu!=100&tsu!=0; for var tr4 tr5 tr6: replace X=. if test==1; for var tr4 tr5 tr6: replace X=. if tsu==0; for var tr4 tr5 tr6: replace X=0 if X==.&tsu==100; drop test tsu;
egen tsu=rsum(tr7 tr8); gen test=1 if tsu!=100&tsu!=0  & country != "Turkiye2015"; for var tr7 tr8: replace X=. if test==1; for var tr7 tr8: replace X=. if tsu==0; for var tr7 tr8: replace X=0 if X==.&tsu==100 & country != "Turkiye2015"; drop test tsu;  /*** condition with Turkey2015 added by Nona on July 5, 2016 ***/;
for var tr1 tr2 : replace X=. if X<0.1;

gen  wk1=100 if l10==1;replace wk1=0 if l10==2;
gen  wk2=l11a*(l3a/l1)+l11b*(l3b/l1) if sector_MS=="Manufacturing"; /*** a0==6 added by josh wimpey 7-2-2009 ***/;
gen  wk3=l4a if sector_MS=="Manufacturing"; /*** AI 4-29-2014 added manf ***/;
gen  wk4=l4b if sector_MS=="Manufacturing"; /*** AI 4-29-2014 added manf ***/;
gen  wk6=l3a if sector_MS=="Manufacturing"; /*** AI 4-29-2014 added manf ***/;
gen  wk7=l3b if sector_MS=="Manufacturing"; /*** AI 4-29-2014 added manf ***/;
gen  wk8=b7; replace wk8=. if wk8>60;
gen  wk9=100 if l30a==3|l30a==4;replace wk9=0 if l30a==0 |l30a==1|l30a==2;
gen  wk10=100 if l30b==3|l30b==4;replace wk10=0 if l30b==0 |l30b==1|l30b==2;
gen  wk11=l6;
gen  wk12=l1;
/*egen _wk13=rowtotal(wk3 wk4), missing; gen  wk13=(wk4/_wk13)*100 if sector_MS=="Manufacturing"; /*** AI 4-29-2014 added manf, turned off by Nona on August 4, 2017 ***/; */;

gen wk15=l3a/l1*100 if l3a !=. & l3b !=. & l1 !=. & l3a + l3b == l1 & sector_MS == "Manufacturing"; /* added by Nona on May 10, 2017 */;
gen wk16=l3b/l1*100 if l3a !=. & l3b !=. & l1 !=. & l3a + l3b == l1 & sector_MS == "Manufacturing"; /* added by Nona on May 10, 2017 */;

gen wk17_temp = l6*(l8/12) if l6>=0 & l8>=0 & l6!=. & l8!=.; /* added by Nona on May 10, 2017 */;
replace wk17_temp = l6*(1/3) if l6>=0 & (l8<0 | l8 ==.) & l6!=. ; /* added by Nona on May 10, 2017 */;
*replace wk17_temp = 0 if s==l1;

gen wk14=l1+l6*(l8/12) if l1>=0 & l6>=0 & l8>=0 & l1!=. & l6!=. & l8!=.;   /* added by Nona on May 10, 2017 */;
replace wk14=l1+l6*(1/3) if l1>=0 & l6>=0 & (l8<0 | l8 ==.) & l1!=. & l6!=. ;  /* added by Nona on May 10, 2017 */;
replace wk14=l1 if l1>=0 & l1!=. & wk14==.;  /* added by Nona on May 10, 2017 */;

gen wk17=wk17_temp/wk14*100 if wk17_temp !=. & l1 !=. & wk14 != . ; /* added by Nona on May 10, 2017 */;
gen wk18=       l1/wk14*100 if wk17_temp !=. & l1 !=. & wk14 != .;  /* added by Nona on May 10, 2017 */;

gen wk13=l4b/l3a*100 if l4a !=. & l4b !=. & l3a !=. & l4a + l4b == l3a & sector_MS == "Manufacturing"; /* added by Nona on May 10, 2017 */;
gen wk19=l4a/l3a*100 if l4a !=. & l4b !=. & l3a !=. & l4a + l4b == l3a & sector_MS == "Manufacturing"; /* added by Nona on May 10, 2017 */;

gen  car2=b2a;
gen  car3=b2b;
gen  b2a_mod=b2a if b2a>=0; gen b2b_mod=b2b if b2b>=0; gen b2c_mod=b2c if b2c>=0; gen b2d_mod=b2d if b2d>=0; egen b2acd=rowtotal(b2a b2c b2d); egen b2abd=rowtotal(b2a b2b b2d);  /** added by Nona on May 1, 2017 **/;
gen  car7=100 if b2b>=10 & b2b !=.; replace car7=0 if b2b<10 & b2b>=0; replace car7=0 if b2a>90&b2a!=.; replace car7=0 if b2c>90&b2c!=.; replace car7=0 if b2d>90&b2d!=.; replace car7=0 if b2acd>90&b2acd!=.; /** added by Nona on May 1, 2017 **/;
gen  car4=b2c;
gen  car8=100 if b2c>=10 & b2c !=.; replace car8=0 if b2c<10 & b2c>=0; replace car8=0 if b2a>90&b2a!=.; replace car8=0 if b2b>90&b2b!=.; replace car8=0 if b2d>90&b2d!=.; replace car8=0 if b2abd>90&b2abd!=.;  /** added by Nona on May 1, 2017 **/;
gen  car5=b2d;

gen  car6=b3;  /*** Moved to after b1 recode March 1 2011, Josh WImpey **/;
replace car6=100 if b1==3 & b3==.;  /***This makes sure that all sole proprieterships are counted as 100% owned by largest owner when b3 is missing. March 1 2011, Josh WImpey **/;

** final cleaning of fin indicators from new3, Ziqiao ** ;
egen tsu=rsum(car2 car3 car4 car5); gen test=1 if tsu!=100&tsu!=0; for var car2 car3 car4 car5: replace X=. if test==1; for var car2 car3 car4 car5: replace X=. if tsu==0; for var car2 car3 car4 car5: replace X=0 if X==.&tsu==100; drop test tsu;

/**********************************************
*Legal form
**********************************************/
gen lform = b1;
replace lform=. if lform>7 | lform==0;
** added by Minh, 29 sept 09;
gen lform1 = (lform==1) & lform~=.;
gen lform2 = (lform==2) & lform~=.;
gen lform3 = (lform==3) & lform~=.;
gen lform4 = (lform==4) & lform~=.;
gen lform5 = (lform==5) & lform~=.;
gen lform6 = (lform==6) & lform~=.;
for var lform1-lform6: recode X 1=100;

# delimit cr

/*******************************************************************************/
/*************************** Management practices ******************************/
/*******************************************************************************/
*This portion was added on April 28, 2023, by Nona, after clearances from David and review from the whole EA team

*Score these variables following Bloom et al (2019) methodology
*https://www.aeaweb.org/articles?id=10.1257/aer.20170491
*Online appendix to: https://www.aeaweb.org/content/file?id=9540
/* full citation
Bloom, Nicholas, Erik Brynjolfsson, Lucia Foster, Ron Jarmin, Megha Patnaik, Itay Saporta-Eksten, and John Van Reenen. "What drives differences in management practices?." American Economic Review 109, no. 5 (2019): 1648-83.
*/

*Don't know responses are coded as zeros (equating them to the worst level of management practice)

*Problem resolution (r1):
	gen mgmt2 = .
	replace mgmt2 = 1 if r1 == 3 // Most structured
	replace mgmt2 = 2/3 if r1 == 2 // Second most structured
	replace mgmt2 = 1/3 if r1 == 1 // Second least structured
	replace mgmt2 = 0 if r1 == 4 // Least structured (No action)

*Number of performance indicators monitored (r3):
	gen mgmt3 = .
	replace mgmt3 = 1 if r3 == 3 // 10 or more indicators
	replace mgmt3 = 2/3 if r3 == 2 // 3-9 indicators
	replace mgmt3 = 1/3 if r3 == 1 // 1-2 indicators
	replace mgmt3 = 0 if r2==2 // No indicators
	
*Targets
	gen mgmt4 = .
	replace mgmt4 = 1 if r5 == 3 // Combination of short-term and long-term targets
	replace mgmt4 = 2/3 if r5 == 2 // Main focus was on long term  targets
	replace mgmt4 = 1/3 if r5 == 1 // Main focus was on short term targets
	replace mgmt4 = 0 if r4==2 // No targets
	
*Level of ease or difficulty to achieve production or service provision targets (r6):
	*See: http://www.oecd.org/global-forum-productivity/events/Day1_A3_Heys.pdf
	gen mgmt5 = . 
	replace mgmt5 = 0 if r6==1 | r4==2 // Possible w/o much effort
	replace mgmt5 = 1/4 if r6 == 5 | r6 == 6 // Possible w/ extraordinary amount effort (answer includes target not achieved)
	replace mgmt5 = 1/2 if r6 == 2 // Possible w/ some effort
	replace mgmt5 = 3/4 if r6 == 3 // Possible w/ normal amount effort
	replace mgmt5 = 1 if r6 == 4 // Possible w/ > normal amount effort
		
*Knowledge of production or service provision targets (r7):
	gen mgmt6 = .
	replace mgmt6 = 0 if r7 == 1 | r4==2 // Only senior managers
	replace mgmt6 = 1/3 if r7 == 2 // Most managers and some workers
	replace mgmt6 = 2/3 if r7 == 3 // Most managers and most workers
	replace mgmt6 = 1 if r7 == 4 // All managers and most workers
		
* Basis of bonuses (ASCr11)
	gen mgmt7 = .
	replace mgmt7 = 0 if r8 == 2 // No performance bonuses
	replace mgmt7 = 1/4 if r9 == 4 // Their company's performance as measured by targets
	replace mgmt7 = 1/2 if r9 == 3 // Their establishment's performance as measured by targets
	replace mgmt7 = 3/4 if r9 == 2 // Their team or shift performance as measured by targets
	replace mgmt7 = 1 if r9 == 1 // Their own performance as measured by targets
		
* Way of promotion of non-managers (r10)
	gen mgmt8 = .
	replace mgmt8 = 0 if r10 == 4 | r10==-7 // Non-managers are normally not promoted
	replace mgmt8 = 1/3 if r10 == 3 // Based mainly on factors other than performance and ability (for example, tenure or family connections)
	replace mgmt8 = 2/3 if r10 == 2 // Based partly on performance and ability, and partly on other factors (for example, tenure or family connections)
	replace mgmt8 = 1 if r10 == 1  // Their own performance as measured by targets
	
* Way of reassignment or dismissal of under-performing non-managers (r11)
	gen mgmt9 = .
	replace mgmt9 = 0 if r11 == 3 // Rarely or never
	replace mgmt9 = 1/2 if r11 == 2 // After 6 months of identifying under-performance
	replace mgmt9 = 1 if r11 == 1 // Within 6 months of identifying under-performance
		
*Generate overall management score using simple average of individual performance scores
	gen mgmt1 = (mgmt2 + mgmt3 + mgmt4 + mgmt5 + mgmt6 + mgmt7 + mgmt8 + mgmt9) / 8
	
*Transform to 100
	foreach var in mgmt2 mgmt3 mgmt4 mgmt5 mgmt6 mgmt7 mgmt8 mgmt9 mgmt1 {
	    replace `var' = `var' * 100
		replace `var' = . if size <=1 // indicators calculated only for 20+ employee establishments
	}
	
/*******************************************************************************/
/****************************  Credit Constraints  *****************************/
/******** added on June 15, 2023 by Nona, in collaboration with Asif ***********/

foreach var in k3a k5a k3bc k3e k3f k3hd k5bc k5e k5f k5hdj k5i k16 k17 k20a1 k4 {
	replace `var' = -99 if `var' == .c // this is for handling negatives  
}

**********************************************
*DEFINE EXTERNAL FINANCE
**********************************************

*Firm has external finance if other than internal funds used for investment or working capita;
	gen externalfin=1 if k3a<100 & k3a>=0
	replace externalfin=1 if k5a>=0 & k5a<100

*Firm has no external finance if firm fully internally funds investment and working capital.
*OR if firm has made no investment but working capital fully funded by internal funds.
	replace externalfin=0 if k3a==100 & k5a==100
	replace externalfin=0 if k3a==100 & k5a==.

*adjustments for  data - by chance there are cases where DK is used, while other variables add up to 100
	replace externalfin=1 if k3bc >0 & k3bc!=.
	replace externalfin=1 if k3e >0 & k3e!=.
	replace externalfin=1 if k3f >0 & k3f!=.
	replace externalfin=1 if k3hd >0 & k3hd!=.

	replace externalfin=1 if k5bc >0 & k5bc!=.
	replace externalfin=1 if k5e >0 & k5e!=.
	replace externalfin=1 if k5f >0 & k5f!=.
	replace externalfin=1 if k5hdj >0 & k5hdj!=.
	replace externalfin=1 if k5i >0 & k5i!=.


*Don't knows are categorized in the following cases 
*(a) internal funds are dont know for both working capital and investment
*(b) internal funds are dont know for working capital and there was no investment
*(c) Internal funds used fully for investment but working capital financing is dont know
*(d) internal funds used fully for working capital, but investment financing is dont know

	gen extfn_dk =1 if k3a<0 & k5a<0 
	replace extfn_dk =1 if k3a<0 & k5a==.
	replace extfn_dk =1 if k3a<0 & k5a==100
	replace extfn_dk =1 if k3a==100 & k5a<0
	
	replace externalfin = . if extfn_dk == 1

**********************************************
*NOT CREDIT CONSTRAINED (NCC)
**********************************************

*Channel1 (original Channels 1 and 3)
	*(ii) Firm did not apply for a loan or line of credit (k16==2)
	*(iii) Firm did not apply as they have enough capital (k17==1)
	*Original1: (i)Firm had a source of external finance (k3a<100 or k5a<100)
	*Original3: (i)Firm did not have a source of external finance (k3a==100 & k5a==100)

	gen ncc_1=.
	replace ncc_1=1 if k16==2 & k17==1
	gen ncc_1_dk=1 if k16<0 | k17<0

	
*Channel2 (original Channels 2 and 4)
	*(ii) Firm applied for a loan or line of credit (k16==1)
	*(iii) Application was approved in full (k20a1==1)
	*Original2: (i)Firm had a source of external finance (k3a<100 or k5a<100)
	*Original3: (i)Firm did not have a source of external finance (k3a==100 & k5a==100)

	gen ncc_2=.
	replace ncc_2 = 1 if k16==1 & k20a1==1
	gen ncc_2_dk=1 if k16<0 | k20a1<0 | k20a1==4


*Combine all channels to obtain unconstrained firms
	gen unconstrained = 1 if ncc_1 ==1 |ncc_2 ==1 
	gen unconst_dk =1 if ncc_1_dk==1 | ncc_2_dk==1 

	replace unconstrained = 0 if  unconstrained!=1 & unconst_dk!=1
	replace unconstrained = -9 if unconst_dk==1

**********************************************
*FULLY CREDIT CONSTRAINED (FCC)
**********************************************

*Channel1
	*(i)Firm did not have a source of external finance (k3a==100 & k5a==100)
	*(ii) Firm did not apply for a loan or line of credit (k16==2)
	*(iii) Reason for no application - reason other than no need (k17>=2 & k17<=7)

	gen fcc_1=.
	replace fcc_1=1 if externalfin==0 & k16==2 & k17>=2 & k17<=7
	gen fcc_1_dk=1 if extfn_dk==1 | k16<0 | k17<0

	*NOTE: EGYPT 2016 HAS AN 8TH OPTION
	replace fcc_1=1 if externalfin==0 & k16==2 & k17>=2 & k17<=8 & country=="Egypt2016"


*Channel2
	*(i)Firm did not have a source of external finance (k3a==100 & k5a==100)
	*(ii) Firm applied for a loan or line of credit (k16==1)
	*(iii) Application was rejected (k20a1==3)

	gen fcc_2=.
	replace fcc_2=1 if externalfin==0 & k16==1 & k20a1==3
	gen fcc_2_dk=1 if extfn_dk==1 | k16<0 | k20a1<0 | k20a1==4


*Channel3
	*(i) Firm obtained financing from equity financing (k5i >0)
	*(ii) Firm applied for a loan or line of credit (k16==1)
	*(iii) Application was rejected (k20a1==3)

	gen fcc_3=.
	replace fcc_3=1  if k5i >0 & k5i!=. & k16==1 & k20a1==3
	gen fcc_3_dk=1 if k5i<0 | k16<0 | k20a1<0 | k20a1==4 


*Combine all channels to obtain fully constrained firms
	gen constrained = 1 if fcc_1 ==1 |fcc_2 ==1 |fcc_3 ==1
	gen const_dk =1 if fcc_1_dk==1 | fcc_2_dk==1 | fcc_3_dk==1 

	replace constrained = 0 if  constrained!=1 & const_dk!=1
	replace constrained = -9 if const_dk==1

**********************************************
*PARTIALLY CREDIT CONSTRAINED (PCC)
**********************************************

*Channel1 
	*(i)Firm had a source of external finance (k3a<100 or k5a<100), excluding equity finance
	*(ii) Firm applied for a loan or line of credit (k16==1)
	*(iii) Application was rejected (k20a1==3)

	gen pcc_1=.
	replace pcc_1=1 if externalfin==1 & k16==1 & k20a1==3 & k5i==0 & k4==1 // k5i is only asked for firms who invested
	replace pcc_1=1 if externalfin==1 & k16==1 & k20a1==3 & (k4==2 | k4==-99) // k5i is only asked for firms who invested
	gen pcc_1_dk=1 if extfn_dk==1 | k16<0 | k20a1<0| k5i<0 | k20a1==4 


*Channel2 (original Channel 2 and 4)
	*(ii) Firm applied for a loan or line of credit (k16==1)
	*(iii) Application was partially approved (k20a1==2)
	*Original2: (i)Firm had a source of external finance (k3a<100 or k5a<100)
	*Original4: (i)Firm did not have a source of external finance (k3a<100 or k5a<100)

	gen pcc_2=.
	replace pcc_2=1 if k16==1 & k20a1==2
	gen pcc_2_dk=1 if k16<0 | k20a1<0 | k20a1==4


*Channel3 - NOTE THIS CHANNEL BECOMES INVALID if k5i is dont know leading pcc_1 to be dont know.
	*(i)Firm had a source of external finance (k3a<100 or k5a<100)
	*(ii) Firm did not apply for a loan or line of credit (k16==2)
	*(iii) Reason for no application - reason other than no need (k17>=2 & k17<=7)

	gen pcc_3=.
	replace pcc_3=1 if externalfin==1 & k16==2 & k17>=2 & k17<=7
	gen pcc_3_dk=1 if extfn_dk==1 | k16<0 | k17<0

	*NOTE: EGYPT 2016 HAS AN 8TH OPTION
	replace pcc_3=1 if externalfin==1 & k16==2 & k17>=2 & k17<=8 & country=="Egypt2016"


*Combine all channels to obtain partially constrained firms
	gen prtconstrained = 1 if pcc_1 ==1 |pcc_2 ==1 | pcc_3==1 
	gen prtconst_dk =1 if pcc_1_dk==1 | pcc_2_dk==1 | pcc_3_dk==1 

	replace prtconstrained = 0 if  prtconstrained!=1 & prtconst_dk!=1
	replace prtconstrained = -9 if prtconst_dk==1
	
*************************************************
***********FULLY SUMMARIZE***********************
*************************************************

	gen cc_sample = 1 if year > 2014 & methodology == "Global"
	// sample definition based on availabilit of variables: k3a k5a k3bc k3e k3f k3hd k5bc k5e k5f k5hdj k5i k16 k17 k20a1 k4
// 	replace cc_sample = 1 if inlist(country, "Djibouti2013", "Egypt2013", "Israel2013", "Jordan2013", "Lebanon2013", "Tunisia2013", "West Bank And Gaza2013", "Yemen2013", "Burundi2014", "Mauritania2014", "Myanmar2014", "Senegal2014", "Sweden2014")
	
	replace cc_sample = 1 if country=="Djibouti2013" |country== "Egypt2013" |country=="Israel2013" |country== "Jordan2013" |country=="Lebanon2013" |country== "Tunisia2013" |country=="West Bank And Gaza2013" |country=="Yemen2013" |country=="Burundi2014" |country=="Mauritania2014" |country=="Myanmar2014" |country=="Senegal2014" |country=="Sweden2014"

	gen creditconstraint = 1 if constrained==1 & cc_sample==1
	replace creditconstraint = 2 if prtconstrained==1 & cc_sample==1
	replace creditconstraint = 3 if unconstrained==1 & cc_sample==1
	
	gen fin23 = 100 if creditconstraint==1 // "Fully Credit Constrained (FCC)"
	replace fin23 =0 if  inlist(creditconstraint,2,3)
	
	gen fin24 = 100 if creditconstraint==2 // "Partially Credit Constrained (PCC)"
	replace fin24 =0 if  inlist(creditconstraint,1,3)
		
	gen fin25 = 100 if creditconstraint==3 // "Credit Unconstrained (NCC)"
	replace fin25 =0 if  inlist(creditconstraint,1,2)
				
	drop cc_sample externalfin extfn_dk ncc_1 ncc_1_dk ncc_2 ncc_2_dk unconstrained unconst_dk fcc_1 fcc_1_dk fcc_2 fcc_2_dk fcc_3 fcc_3_dk constrained const_dk pcc_1 pcc_1_dk pcc_2 pcc_2_dk pcc_3 pcc_3_dk prtconstrained prtconst_dk creditconstraint
	
	
# delimit ;


****************************************************************************************************************************************************************************************;
* Indicators added on June 26, 2024, by Nona, in consultation with Jorge, Josh, Arvind, David, and Gemechu. These indicators include those used in B-READY 1 ;
****************************************************************************************************************************************************************************************;
	gen reg9=j43 if j43>=0;
	gen reg10=100 if inlist(l40,1)==1; replace reg10=0 if inlist(l40,2)==1;
	gen reg11=100 if inlist(l41,1)==1; replace reg11=0 if inlist(l41,2)==1;
	gen reg12=0 if g30a==0; replace reg12=25 if g30a==1; replace reg12=50 if g30a==2; replace reg12=75 if g30a==3; replace reg12=100 if g30a==4; // edited for scale on September 18, 2025 ;
	gen tax1=j35a_j35b if j35a_j35b>=0;
	gen tax2=100 if inlist(j36,1,2)==1; replace tax2=0 if inlist(j36,3)==1;
	gen tax3=100 if inlist(j37,1,2)==1; replace tax3=0 if inlist(j37,3)==1;
	gen tax4=j33 if j33>=0;
	gen tax5=j39 if j39>=0;
	gen tax6=100 if inlist(j40,1,2)==1; replace tax6=0 if j38==1;
	gen tax7 = n2a2_n2a if n2a2_n2a>=0;
	gen tax8=n11 if n11>=0;
	gen fin26=100 if inlist(k17,2,3,4)==1; replace fin26=0 if inlist(k17,1,5,6,7)==1;
	gen fin27=k32 if k32>=0;
	gen fin28=k33 if k33>=0;
	gen fin29=k35 if k35>=0;
	gen fin30=k36 if k36>=0;
	gen fin31=k38 if k38>=0;
	gen fin32=k40 if k40>=0;
	gen fin33=0 if k30==0; replace fin33=25 if k30==1; replace fin33=50 if k30==2; replace fin33=75 if k30==3; replace fin33=100 if k30==4; // edited for scale on September 18, 2025 ;
	gen in18=100 if inlist(c152,1)==1; replace in18=0 if inlist(c152,2)==1;
	gen in19=c162 if c162 >=0;
	gen in20=c172 if c172 >=0;
	gen in21=100 if inlist(c39,1)==1; replace in21=0 if inlist(c39,2)==1;
	gen in22=c37 if c37>=0;
	gen in23=0 if d30a==0; replace in23=25 if d30a==1; replace in23=50 if d30a==2; replace in23=75 if d30a==3; replace in23=100 if d30a==4; // edited for scale on September 18, 2025 ;
	gen in24=100 if inlist(ge3,1)==1; replace in24=0 if inlist(ge3,2)==1;
	gen in25=100 if inlist(ge7,1)==1; replace in25=0 if inlist(ge7,2)==1;
	gen in26=100 if inlist(ge8d,1)==1; replace in26=0 if inlist(ge8d,2)==1;
	gen gend7=0 if j42==1 & !( (b4==2 & (b7a == -9|b7a==.)) | ((b4==-9|b4==.) & b7a == 2) | ((b4==-9|b4==.) & (b7a == -9|b7a==.)) ); replace gend7=100 if gend7==0 & (b4==1 | b7a == 1);
	gen gend8=l12a if l12a >=0 ; replace gend8 = l12a1 / ( (gend2/100) * l1 ) * 100 if l12a1 >=0 & l12a1 !=. & gend2 != . & l1 >= 0 & l1 !=. ; replace gend8 = . if (!inrange(gend8,0,100))|sector_MS!="Manufacturing"; // gend2 being divided by 100 added on December 10, 2025 by Nona, Ziad, Phoebe, per mistake documented in the indicator-description ;
	gen gend9=l12a if l12a >=0 ; replace gend9 = l12a1 / ( (gend2/100) * l1 ) * 100 if l12a1 >=0 & l12a1 !=. & gend2 != . & l1 >= 0 & l1 !=. ; replace gend9 = . if (!inrange(gend9,0,100))|sector_MS=="Manufacturing"; // gend2 being divided by 100 added on December 10, 2025 by Nona, Ziad, Phoebe, per mistake documented in the indicator-description ;
	gen tr18=d33a_d33b_days if d33a_d33b_days>=0;
	
	egen temp=count(tr18), by(country);
	gen tr18_u=tr18; replace tr18_u = 0 if tr18 == . & inlist(d1a1a,1,3) & (d4a == -7 | d4 == -7) & temp >0 ; drop temp; // added by Nona on Sept 18, 2025 ;		
	
	gen tr19=100 if inlist(d35,1)==1; replace tr19=0 if inlist(d35,2)==1;
	gen tr20=d34 if d34>=0;

	egen temp_d12 = count(d12b), by(sector_MS country); egen temp_d12_count = min(temp_d12), by(country); 
	gen  tr21=100 if (d12b>0 & d12b~=.) & temp_d12_count > 0 & year >= 2016 ; replace tr21=0 if d12b==0 & temp_d12_count > 0  & year >= 2016; drop temp_d12 temp_d12_count ; /*** edited by Nona on July 17, 2025, when mistake was detected, original code was: gen tr21=100 if d13==1 replace tr21=0 if d13==2***/;

	gen tr22=d12b if d12b >=0;
	gen tr23=d14 if d14 >=0; // changed to d14 from d14a by Nona on May 22, 2025; 
	gen tr24=d40a_d40b if d40a_d40b>=0;

	egen temp=count(tr24), by(country);
	gen tr24_u=tr24; replace tr24_u = 0 if tr24_u == . & (d14 == -7 | d14a == -7) & temp >0 ; drop temp ; // added by Nona on Sept 18, 2025, condition tr24_u == .  to override one observation where the follow-up is inconsistent with the baseline, taking the follow-up  ;	
	
	gen tr25=d41 if d41>=0;
	gen tr26=0 if d30b==0; replace tr26=25 if d30b==1; replace tr26=50 if d30b==2; replace tr26=75 if d30b==3; replace tr26=100 if d30b==4; // edited for scale on September 18, 2025 ;
	gen comp1 = 0 if e31a_e31b == 1 & e1 != 3; replace comp1 = 50 if e31a_e31b == 2 & e1 != 3; replace comp1 = 100 if e31a_e31b == 3 & e1 != 3;
	replace comp1 = 0 if e312 == 1 & e1 != 3; replace comp1 = 50 if e312 == 2 & e1 != 3; replace comp1 = 100 if e312 == 3 & e1 != 3 ; // added by Nona on November 1, 2024, per suggestion from Antoni Albert Nogues Comas; 
	gen comp2=100 if (e2b<2&e2b>=0 & e1 != 3); replace comp2=0 if ((e2b>=2&e2b!=.)|e2b==-4) & e1 != 3;
	gen comp3=0 if ((e2b>=0&e2b!=.)|e2b==-4) & e1 != 3; replace comp3=100 if (e2b>=2&e2b<=5 & e1 != 3);
	gen comp4=100 if ((e2b>5&e2b!=.)|e2b==-4) & e1 != 3; replace comp4=0 if (e2b<=5&e2b>=0 & e1 != 3);
	gen comp5=0 if inlist(e33,1)==1; replace comp5=100 if inlist(e33,2)==1;
	gen comp6=100 if inlist(e33,-7)==1; replace comp6=0 if inlist(e33,1,2,-6)==1;
	gen comp7= 0 if e32 == 2; replace comp7 = 50 if e32 == 3; replace comp7 = 100 if e32 == 1;
	gen comp8=100 if inlist(c42,4)==1; replace comp8=50 if inlist(c42,3,2)==1; replace comp8=0 if inlist(c42,1)==1;
	gen comp9=100 if inlist(j41,1)==1; replace comp9=2/3*100 if inlist(j41,2)==1; replace comp9=1/3*100 if inlist(j41,3)==1; replace comp9=0 if inlist(j41,4)==1; // edited for scale on September 18, 2025 ;
	gen disp1=100 if inlist(o1,1)==1; replace disp1=0 if inlist(o1,2)==1;
	gen disp2=100 if inlist(o2,1)==1; replace disp2=0 if inlist(o2,2)==1;
	gen disp3=100 if inlist(j31,1,2)==1; replace disp3=0 if inlist(j31,3,4)==1; // edited for scale on September 18, 2025 ;
	gen disp4=100 if inlist(o3a,1,2)==1; replace disp4=0 if inlist(o3a,3,4)==1; // edited for scale on September 18, 2025 ;
	gen disp5=100 if inlist(o3b,1,2)==1; replace disp5=0 if inlist(o3b,3,4)==1; // edited for scale on September 18, 2025 ;
	gen disp6=0 if h30==0; replace disp6=25 if h30==1; replace disp6=50 if h30==2; replace disp6=75 if h30==3; replace disp6=100 if h30==4; // edited for scale on September 18, 2025 ;
	gen wk20=100 if b3a==1; replace wk20=0 if b3a==2;
	gen wk23=l9b if l9b !=.; replace wk23=. if l9b== -9;
	gen wk24=l35 if l35>=0;
	gen wk25=l36 if l36>=0;
	gen wk26=100 if inlist(l37,1)==1; replace wk26=0 if inlist(l37,2)==1;
	gen wk27=l38 if l38>=0;
	gen wk28=0 if l30a==0; replace wk28=25 if l30a==1; replace wk28=50 if l30a==2; replace wk28=75 if l30a==3; replace wk28=100 if l30a==4; // edited for scale on September 18, 2025 ;
	gen t11=100 if (inlist(h1,1)==1& inlist(h5,1)==1&inlist(h8,1)==1&inlist(size,2,3)==1); replace t11=0 if (inlist(h1,2)==1 | inlist(h5,2)==1| inlist(h8,2)==1)&inlist(size,2,3)==1;

	gen wk21 = s;
	gen wk22= l1/wk21*100 if l1 !=. & wk21 != .;
	
****************************************************************************************************************************************************************************************;
* END OF indicators added on June 26, 2024, by Nona, in consultation with Jorge, Josh, Arvind, David, and Gemechu. These indicators include those used in B-READY 1 ;
****************************************************************************************************************************************************************************************;


bys country b1: egen _b1group = sum(wt); 
bys country: egen _b1total = sum(wt); 
gen lformfpct = (_b1group/_b1total)*100; drop _b1group _b1total;

** most common legal form **;
sort country lformfpct; 
bys country : gen lform_max = b1[_N];

** % of limited companies ** ;
** b1==1/2 **;
bys country b1: gen ns = _N if (b1==1 | b1==2); 
bys country: gen tns = _N; 
gen lparpct = (ns/tns)*100;
sort country lparpct;
bys country: replace lparpct =lparpct[1] if lparpct==.;
drop ns tns;

** % of firm per sizes **;
gen sizfpct1 =(size==1) if size~=.;
gen sizfpct2 =(size==2) if size~=.;
gen sizfpct3 =(size==3) if size~=.;
recode sizfpct1  sizfpct2  sizfpct3 (1=100);

*--7. Get % per size, moved here by Ziqiao from new3 -------------------------;
gen sizfpct = .;
replace sizfpct =  sizfpct1 if size==1;
replace sizfpct =  sizfpct2 if size==2;
replace sizfpct =  sizfpct3 if size==3;

** Number of subnational regions **;
bys country a2: gen ch = _N if _n==_N;
bys country: egen nregion=count(ch);
drop ch;

** % of firms per subnational region (without weight)**;
bys country a2: gen ns = _N if a2~=.;
bys country: gen tns = _N;
gen regfpct = (ns/tns)*100;
drop ns tns;

** % of firms invested in fixed assets **;
gen purfixed = (k4==1) if k4~=.;
recode purfixed (1=100);

** % of firms invested in equipment **;
gen _t1 = (n5a>0) if n5a~=.;
bys country _t1: gen ns = _N if _t1==1; 
bys country: gen tns = _N; 
gen purequip = (ns/tns)*100;
sort country purequip;
bys country: replace purequip =purequip[1] if purequip==.;
drop ns tns _t1;

** % of firms invested in land and buildings **;
gen _t1 = (n5b>0) if n5b~=.;
bys country _t1: gen ns = _N if _t1==1; 
bys country: gen tns = _N; 
gen purland = (ns/tns)*100;
sort country purland;
bys country: replace purland =purland[1] if purland==.;
drop ns tns _t1;

**	Obstacles	**;
cap drop obst*;
foreach var of varlist m1a{;
	foreach num of numlist 1/15{;
		g obst`num'=1 if `var'==`num';
		};
	};

for var obst*: replace X=0 if X==.&m1a!=.;
for var obst*: recode X 1=100;


** count number of sectors ;
bys country sector: gen ch = _N if _n==_N;
bys country: egen nsector=count(ch);
drop ch;
** end of count **;

** % of firms per sector **;
bys country sector: gen ns = _N;
bys country: gen tns = _N;
gen secfpct = (ns/tns)*100;
drop ns tns;

*--8. Get % per sector, moved here by Ziqiao from new3 -------------------------;
gen secfpct1 =  secfpct if sector==1;
gen secfpct2 =  secfpct if sector==2;
gen secfpct3 =  secfpct if sector==3;
gen secfpct5 =  secfpct if sector==5;
gen secfpct7 =  secfpct if sector==7;
gen secfpct8 =  secfpct if sector==8;
gen secfpct9 =  secfpct if sector==9;
gen secfpct11 =  secfpct if sector==11;
gen secfpct12 =  secfpct if sector==12;
gen secfpct15 =  secfpct if sector==15;
gen secfpct16 =  secfpct if sector==16;
gen secfpct21 =  secfpct if sector==21;
gen secfpct22 =  secfpct if sector==22;
gen secfpct23 =  secfpct if sector==23;
gen secfpct30 =  secfpct if sector==30;


keep unitconverter fyear n3_l2_year d2_l1_year_perf_indicators n3_l2_year_perf_indicators d2_n3_last_month_fy_perf_ind country2 country_official ccode idstd wbcode isic isic_v4 sector_3 country_abr s a0 a2_2 a3a a3ax a4b country country_proper year region_WB sector2 d1a2 d1a2_v4 ownership exporter size wt wt_6_followups wt_5a_followups wt_5b_followups wt_5c_followups wt_4a_followups wt_4b_followups lform a3 a2 obst1 obst2 obst3 obst4 obst5 obst6 obst7 obst8 obst9 obst10 obst11 obst12 obst13 obst14 obst15 reg1 reg2 reg4 reg5 reg6 reg7 reg8 reg1 reg9 reg10 reg11 reg8 reg12 reg2_c bus1 bus2 bus3 bus5 corr4 corr1 corr11 corr2 corr3 corr5 corr6 corr7 corr8 corr9 corr10 corr12 crime1 crime2 crime3 crime5 crime10 fin17 fin18 crime8 crime9 crime3_c crime2_c infor3 infor1 infor2 infor4 infor5 infor6 gend1 gend2 gend3 gend4 gend5 gend6 gend7 gend8 gend9 mgmt1 mgmt2 mgmt3 mgmt4 mgmt5 mgmt6 mgmt7 mgmt8 mgmt9 fin1 fin2 fin3 fin4 fin5 fin6 fin7 fin8 fin9 fin10 fin11 fin12 fin13 fin14 fin15 fin16 fin17 fin18 fin19 fin20 fin21 fin22 fin23 fin24 fin25 fin26 fin27 fin28 fin29 fin30 fin31 fin32 fin33 in1 in2 in3 in4 in5 in6 in7 in8 in9 in10 in11 in12 in14 in15 in16 in17 in18 in19 in20 in21 in22 in23 in24 in25 in26 in3_c in4_c in7_c in10_c t1 t2 t3 t4 t5 t6 tr1 tr2 tr4 tr5 tr6 tr7 tr8 tr9 tr10 tr11 tr12 tr13 tr14 tr15 tr17 tr16 tr18 tr18_u tr19 tr20 tr21 tr22 tr23 tr24 tr24_u tr25 tr26 wk1 wk2 wk3 wk4 wk6 wk7 wk8 wk9 wk10 wk11 wk12 wk13 wk14 wk15 wk16 wk17 wk18 wk19 wk20 wk21 wk22 wk23 wk24 wk25 wk26 wk27 wk28 car1 car2 car3 car4 car5 car6 car7 car8 graft1 graft1b graft2 lparpct lformfpct lform_max nsector secfpct sizfpct1 sizfpct2 sizfpct3 nregion regfpct strata graftsum tgraft egraft wgraft cgraft igraft ograft  jgraft reg2_c sme usefin1 usefin2 usefin3 usefin4 usefin5 usefin6 graftsum tgraft egraft wgraft cgraft igraft ograft graft3 perf1 perf2 perf3 perf4 perf5* stra_sector sector_MS deflator_adjust_d2 exrate_d2 deflator_adjust_n3 exrate_n3 tax1 tax2 tax3 tax4 tax5 tax6 tax7 tax8 reg4  comp1 comp2 comp3 comp4 comp5 comp6 comp7 comp8 comp9 graft3 graft2  graft1 disp1 disp2 disp3 disp4 disp5 disp6 t7 t7_ml t8 t9 t9_ml t10 t11 t1 t3 t4 t5 lform lform_max   lformfpct lform1-lform6 sizfpct secfpct1-secfpct30 sector;
