
#delimit ;
pause on;

/********************************************************************************************
Intermediate file for generating indicators

********************************************************************************************/

svyset, clear;
svyset idstd [pw=wt], strata(strata) singleunit(scaled);
	

/********************************************************************************************1. create and fix isic, stra_sector
********************************************************************************************/
replace d1a2_v4 = . if country == "Germany2021" | country == "Austria2021" ;

*-- generate isic variable -------------------------;
cap drop isic;
g isic=int(d1a2/100) if d1a2>999 & d1a2~=.;
replace isic = int(d1a2/10) if d1a2<=999 & d1a2>99 &d1a2~=.;
replace isic = d1a2 if d1a2<99 & d1a2~=. & d1a2>=10;
replace isic=52 if isic==11 & country!="Russia2012";
replace isic=27 if isic==38;

*-- fix isic Lebanon 2009-------------------------;
replace isic= 21 if isic==210 & country=="Lebanon2009";
replace isic= 70 if isic==702 & country=="Lebanon2009";
replace d1a2=2101 if d1a2==21012 & country=="Lebanon2009";
replace d1a2=7025 if d1a2==70250 & country=="Lebanon2009";

sort country idstd;

#delimit cr

** Minh, Oct 09 **
*cap drop stra_sector
cap gen str10 stra_sector= ""

** add more isic/a2 into data
sort idstd
merge idstd using "$global_inputs_replication\\isicdta.dta", sort update replace
drop if _m==2
drop _m

replace d1a2=. if d1a2<0

merge 1:1 idstd using "$global_outputs\\temp_strasector.dta", keep(1 3)
replace stra_sector = StraSector if _m == 3
drop StraSector _m

erase "$global_outputs\\temp_strasector.dta"

** Micronesia, Fed. Sts.2009, Samoa2009, Vanuatu2009 Tonga2009 Timor-Leste2009
replace stra_sector = "Manufacturing" if isic>=10 & isic <=36 & (country=="Micronesia, Fed. Sts.2009" | country=="Tonga2009" | country=="Samoa2009" | country=="Vanuatu2009" | country=="Timor-Leste2009" | country=="Fiji2009") 
replace stra_sector = "Services" if isic>=45 & isic <=74 & (country=="Micronesia, Fed. Sts.2009" | country=="Samoa2009" | country=="Tonga2009" | country=="Vanuatu2009" | country=="Timor-Leste2009" | country=="Fiji2009") & stra_sector == ""

** Philippines2009
replace stra_sector = "15" if isic==15 & country=="Philippines2009"
replace stra_sector = "18" if isic==18 & country=="Philippines2009"
replace stra_sector = "24" if isic==24 & country=="Philippines2009"
replace stra_sector = "25" if isic==25 & country=="Philippines2009"
replace stra_sector = "26" if isic==26 & country=="Philippines2009"
replace stra_sector = "52" if isic==52 & country=="Philippines2009"
replace stra_sector = "31-32" if (isic==31 | isic==32) & country=="Philippines2009"
replace stra_sector = "Other Manufacturing" if (isic==16 | isic==17 | isic==19 | isic==20 |isic==21 | isic==22 | isic==23 | isic==27 | isic==28 | isic==29 | isic==30 | isic==33| isic==34 | isic==35 | isic==36 | isic==37) & country=="Philippines2009"
replace stra_sector = "Other Services" if (isic==45 | isic==50 | isic== 51 | isic== 55 | isic== 60 | isic==61 | isic==62 | isic==63 | isic==64 | isic== 72) & country=="Philippines2009"

** Vietnam2009
replace stra_sector = "15" if isic==15 & country=="Viet Nam2009"
replace stra_sector = "17" if isic==17 & country=="Viet Nam2009"
replace stra_sector = "18" if isic==18 & country=="Viet Nam2009"
replace stra_sector = "26" if isic==26 & country=="Viet Nam2009"
replace stra_sector = "28" if isic==28 & country=="Viet Nam2009"
replace stra_sector = "52" if isic==52 & country=="Viet Nam2009"
replace stra_sector = "Other Manufacturing" if (isic==16 | isic>=19 & isic<=25) & country=="Viet Nam2009"
replace stra_sector = "Other Manufacturing" if (isic==24 | isic==25 | isic==27| isic==29 | isic==30| isic==31 | isic==32 | isic==34 | isic==35 | isic==36) & country=="Viet Nam2009"
replace stra_sector = "Other Services" if (isic==45 | isic==50 | isic==51 | isic==55 |isic==60 | isic==61 | isic==62 | isic==63| isic==64|isic==72) & country=="Viet Nam2009"
replace stra_sector = "Other Manufacturing" if (idstd==466323 | idstd==466115 | idstd==466133 | idstd==466324 | idstd==466381 | idstd==466905 | idstd==466914 | idstd==466919 | idstd==466925 | idstd==467031 | idstd==466121| idstd==466201| idstd==466946)
replace stra_sector = "15" if idstd==466186 | idstd==466389
replace stra_sector = "Other Services" if idstd==466327| idstd==466457|idstd==466945

** Indonesia2009
replace stra_sector = "15" if isic==15 & country=="Indonesia2009"
replace stra_sector = "17" if isic==17 & country=="Indonesia2009"
replace stra_sector = "18" if isic==18 & country=="Indonesia2009"
replace stra_sector = "24" if isic==24 & country=="Indonesia2009"
replace stra_sector = "25" if isic==25 & country=="Indonesia2009"
replace stra_sector = "26" if isic==26 & country=="Indonesia2009"
replace stra_sector = "52" if isic==52 & country=="Indonesia2009"
replace stra_sector = "Other Manufacturing" if (isic==16 | isic>=19 & isic<24) & country=="Indonesia2009"
replace stra_sector = "Other Manufacturing" if isic>=27 & isic<=37 & country=="Indonesia2009"
replace stra_sector = "Other Services" if (isic==45 | isic==50 | isic== 51 | isic== 55 | isic== 60 | isic==61 | isic==62 | isic==63 | isic==64 | isic== 72) & country=="Indonesia2009"
replace stra_sector = "15" if idstd==467853|idstd==467854|idstd==467978
replace stra_sector = "Other Services" if idstd==468420|idstd== 468423|idstd== 468425

** Laos 2009
replace stra_sector = "Manufacturing" if isic>=15 & isic<=37 & country=="Lao PDR2009"
replace stra_sector = "Retail" if isic==52 & country=="Lao PDR2009"
replace stra_sector = "Other Services" if (isic==45|isic==50|isic==51|isic==55|isic==60|isic==63|isic==64|isic==72) & country=="Lao PDR2009"

** Brazil 2009**
replace stra_sector = "15" if isic==15 & country=="Brazil2009"
replace stra_sector = "17" if isic==17 & country=="Brazil2009"
replace stra_sector = "18" if isic==18 & country=="Brazil2009"
replace stra_sector = "19" if isic==19 & country=="Brazil2009"
replace stra_sector = "24" if isic==24 & country=="Brazil2009"
replace stra_sector = "29" if isic==29 & country=="Brazil2009"
replace stra_sector = "34" if isic==34 & country=="Brazil2009"
replace stra_sector = "36" if isic==36 & country=="Brazil2009"
replace stra_sector = "52" if isic==52 & country=="Brazil2009"
replace stra_sector = "72" if isic==72 & country=="Brazil2009"
replace stra_sector = "Other Manufacturing" if (isic==16 | isic==20 | isic==21 | isic==22 | isic==23 | isic==25 | isic==26 | isic==27 | isic==28 | isic==30 | isic==31 | isic==32 | isic==33 | isic==35 | isic==37) & country=="Brazil2009"
replace stra_sector = "Other Services" if (isic==45 | isic==50 | isic== 51 | isic== 55 | isic== 60 | isic== 61| isic== 62  | isic==63 | isic== 64) & country=="Brazil2009"
*replace stra_sector = "Other Manufacturing" if isic==. & country=="Brazil2009" & (sector_3==1|sector_3==3)
*replace stra_sector = "Other Services" if isic==. & country=="Brazil2009" & sector_3==2

#delimit;

*replace stra_sector = "Manufacturing" if sector_3==1 & stra_sector =="";
replace stra_sector = "Manufacturing" if ((isic>14 & isic<=37)|(inlist(isic,10,11,13,14,.)&sector2==1)) & stra_sector =="";

*replace stra_sector = "Services" if sector_3==2 & stra_sector =="";
replace stra_sector = "Services" if ((isic==52)|(inlist(isic,.)&sector2==2)) & stra_sector =="";

*replace stra_sector = "Residual" if sector_3==3 & stra_sector =="";
replace stra_sector = "Residual" if ((isic>37 & isic<52) | (isic>52 & isic!=.)) & stra_sector =="";
replace stra_sector = "Residual" if stra_sector =="";

foreach cty in `"Azerbaijan2009"' `"Benin2009"' `"Bosnia and Herzegovina2009"' `"Bulgaria2009"' `"Burkina Faso2009"' `"Cameroon2009"' `"Cabo Verde2009"' `"Chad2009"' `"Congo2009"' `"Cyprus2019"' `"Czechia2009"' `"Cote d'Ivoire2009"' `"Cote d'Ivoire2016"' `"Dominican Republic2016"' `"Egypt2007"' `"Egypt2016"' `"Eritrea2009"' `"Estonia2009"' `"Ethiopia2015"' `"Georgia2019"' `"Guatemala2017"' `"Honduras2016"' `"Hungary2009"' `"Indonesia2015"' `"Kazakhstan2009"' `"Kazakhstan2019"' `"Kosovo2009"' `"Kyrgyz Republic2009"' `"Latvia2009"' `"Lithuania2009"' `"Madagascar2009"' `"Malawi2009"' `"Mauritius2009"' `"Moldova2009"' `"Moldova2019"' `"Mongolia2009"' `"Montenegro2009"' `"Morocco2007"' `"Niger2009"' `"North Macedonia2009"' `"Philippines2015"' `"Poland2009"' `"Romania2009"' `"Russia2009"' `"Russia2019"' `"Serbia2009"' `"Slovakia2009"' `"Slovenia2009"' `"Suriname2018"' `"Tajikistan2008"' `"Tajikistan2019"' `"Tanzania2013"' `"Thailand2006"' `"Togo2009"' `"Uzbekistan2008"' `"Uzbekistan2013"' `"Uzbekistan2019"' `"Viet Nam2015"' {;
	replace a3ax = proper(a3ax) if country == "`cty'";
};

** add more isic to the data;
replace isic=15 if stra_sector=="15" & isic==.;
replace isic=18 if stra_sector=="18" & isic==.;
replace isic=24 if stra_sector=="24" & isic==.;
replace isic=29 if stra_sector=="29" & isic==.;
replace isic=52 if stra_sector=="52" & isic==.;
replace isic=72 if stra_sector=="72" & isic==.;


**************DRC 2010 - Asif 10-27-2010****  UPDATED by JW 9-13-2011   ****;
replace stra_sector = "Manufacturing" if (isic==15|isic==17|isic==18|isic==31|isic==24|isic==25|isic==26| isic==27| isic==28| isic==29|isic==16|isic==19|isic==20|isic==21|isic==22|isic==32|isic==34|isic==36) & country=="DRC2010";
replace stra_sector = "Retail" if isic==52 & country=="DRC2010";
replace stra_sector = "Other Services" if (isic==45|isic==50|isic==51|isic==54|isic==55|isic==60|isic==61|isic==62|isic==63|isic==64|isic==72) & country=="DRC2010";

**************ANGOLA 2010 - Asif 1-31-2011***  UPDATED by JW 9-13-2011   **;
replace stra_sector = "Manufacturing" if (isic==15|isic==17|isic==18|isic==31|isic==16|isic==19|isic==20|isic==21|isic==22|isic==32|isic==34|isic==36|isic==24|isic==25|isic==26|isic==27|isic==28|isic==29) & country=="Angola2010";
replace stra_sector = "Retail" if isic==52 & country=="Angola2010";
replace stra_sector = "Other Services" if (isic==45|isic==50|isic==51|isic==54|isic==55|isic==60|isic==61|isic==62|isic==64|isic==72) & country=="Angola2010";

**************BOTSWANA 2010 - Asif 1-31-2011****  UPDATED by JW 9-13-2011   ****;
replace stra_sector = "Manufacturing" if (isic==15|isic==17|isic==18|isic==31|isic==16|isic==19|isic==20|isic==21|isic==22|isic==32|isic==34|isic==36|isic==24|isic==25|isic==26|isic==27|isic==28|isic==29) & country=="Botswana2010";
replace stra_sector = "Retail" if isic==52 & country=="Botswana2010";
replace stra_sector = "Other Services" if (isic==45|isic==50|isic==51|isic==54|isic==55|isic==60|isic==61|isic==63|isic==64|isic==72) & country=="Botswana2010";

**************MALI 2010 - Asif 1-31-2011****  UPDATED by JW 9-13-2011   ***;
replace stra_sector = "Manufacturing" if (isic==15|isic==17|isic==18|isic==31|isic==16|isic==19|isic==20|isic==21|isic==22|isic==23|isic==32|isic==34|isic==36|isic==24|isic==25|isic==26|isic==27|isic==28|isic==29) & country=="Mali2010";
replace stra_sector = "Retail" if isic==52 & country=="Mali2010";
replace stra_sector = "Other Services" if (isic==45|isic==50|isic==51|isic==52|isic==55|isic==60|isic==61|isic==62|isic==63|isic==64|isic==72) & country=="Mali2010";

# delimit cr

/*** Recode BEEPS 2009 ****/
replace stra_sector="Retail" if stra_sector=="Services" & year==2009 & region==3
replace stra_sector="Other Services" if stra_sector=="Residual" & year==2009 & region==3
replace stra_sector="Retail" if stra_sector=="Services" & country=="Mongolia2009"
replace stra_sector="Other Services" if stra_sector=="Residual" & country=="Mongolia2009"

#delimit ;

*** Display ISIC text online **;
replace stra_s="Food products and beverages" if stra_s=="15";
replace stra_s="Textiles" if stra_s=="17";
replace stra_s="Apparel" if stra_s=="18";
replace stra_s="Leather products" if stra_s=="19";
replace stra_s="Wood and wood products" if stra_s=="20";
replace stra_s="Paper and paper products" if stra_s=="21";
replace stra_s="Publishing" if stra_s=="22";
replace stra_s="Chemicals and chemical products" if stra_s=="24";
replace stra_s="Rubber and plastics products" if stra_s=="25";
replace stra_s="Non-metallic mineral products" if stra_s=="26";
replace stra_s="Fabricated metal products" if stra_s=="28";
replace stra_s="Machinery and equipment" if stra_s=="29";
replace stra_s="Mobile vehicles" if stra_s=="34";
replace stra_s="Furniture" if stra_s=="36";
replace stra_s="Retail" if stra_s=="52";
replace stra_s="IT and IT services" if stra_s=="72";
replace stra_s="Basic and fabricated metal products" if stra_s=="27-28";
replace stra_s="Electrical machinery and electronics" if stra_s=="31-32";


#delimit cr

*- Added by Xie Apr.15.2014 -*
replace stra_sector="Construction" if stra_sector=="Construction: Section F"
replace stra_sector="Hotels & Restaurants" if stra_sector=="Hotel and restaurants: Section H"
replace stra_sector="Machinery & Equipment" if stra_sector=="Machinery and equipment"
replace stra_sector="Non-Metallic Mineral Products" if stra_sector=="Non metallic mineral products"
replace stra_sector="Chemicals & Plastics & Rubber" if stra_sector=="Plastics & rubber"
replace stra_sector="Other Services" if stra_sector=="Post and telecommunications"
replace stra_sector="Other Manufacturing" if stra_sector=="Recorded media"
replace stra_sector="Supporting Transport Activities" if stra_sector=="Supporting Transport activities"
replace stra_sector="Supporting Transport Activities" if stra_sector=="Transport (60-62)"


#delimit;


*cap drop  filename stra_new;

replace stra_sector="Food" if stra_sector=="Food";
replace stra_sector="Food" if stra_sector=="Food products and beverages";
replace stra_sector="Textiles" if stra_sector=="Textiles";
replace stra_sector="Textiles & Garments" if stra_sector=="Textiles & Garments";
replace stra_sector="Garments" if stra_sector=="Apparel";
replace stra_sector="Garments" if stra_sector=="Garments";
replace stra_sector="Leather Products" if stra_sector=="Leather products";
replace stra_sector="Textiles, Garments, Leather & Paper" if stra_sector=="ISIC 17-21";
replace stra_sector="Printing & Publishing" if stra_sector=="Printing & Publishing";
replace stra_sector="Chemicals & Chemical Products" if stra_sector=="Chemicals and chemical products";
replace stra_sector="Rubber & Plastics Products" if stra_sector=="Rubber and plastics products";
replace stra_sector="Non-Metallic Mineral Products" if stra_sector=="Non-metallic mineral products";
replace stra_sector="Fabricated Metal Products" if stra_sector=="Fabricated metal products";
replace stra_sector="Fabricated Metal Products" if stra_sector=="Metal Fabrication";
replace stra_sector="Machinery & Equipment" if stra_sector=="Machinery and equipment";
replace stra_sector="Chemicals, Plastics & Rubber" if stra_sector=="Chemicals/Plastics & Rubber";
replace stra_sector="Chemicals, Non-Metallic Mineral, Plastics & Rubber" if stra_sector=="ISIC 24-26";
replace stra_sector="Basic Metals & Metal Products" if stra_sector=="Basic and fabricated metal products";
replace stra_sector="Basic Metals, Machinery, & Metal Products" if stra_sector=="Basic Metals/Fabricated Metals/Machiner";
replace stra_sector="Electronics" if stra_sector=="Electrical machinery and electronics";
replace stra_sector="Motor Vehicles" if stra_sector=="Mobile vehicles";
replace stra_sector="Furniture" if stra_sector=="Furniture";
replace stra_sector="Manufacturing" if stra_sector=="Manufacturing";

*edited out 5.30.2012;
*replace stra_sector="Food, Machinery & Electronics" if stra_sector=="Stratum 1";
*replace stra_sector="Textiles, Garments, Leather, Paper & Publishing" if stra_sector=="Stratum 2";
*replace stra_sector="Minerals, Basic Metals & Metal Products" if stra_sector=="Stratum 3";
*replace stra_sector="Wood Products & Furniture" if stra_sector=="Stratum 4";
*replace stra_sector="Fuels, Chemicals, Plastics & Rubber" if stra_sector=="Stratum 5";
replace stra_sector="Other Manufacturing" if stra_sector=="Other Manufacturing";
replace stra_sector="Construction" if stra_sector=="Construction";
replace stra_sector="Wholesale" if stra_sector=="Wholesale";
replace stra_sector="Retail" if stra_sector=="Retail";
replace stra_sector="Retail" if stra_sector=="Stratum 6";
replace stra_sector="Retail & IT" if stra_sector=="Retail & IT";
replace stra_sector="Hotels & Restaurants" if stra_sector=="Hotels & Restaurants";
replace stra_sector="IT & IT Services" if stra_sector=="IT and IT services";
replace stra_sector="Services" if stra_sector=="Services";
replace stra_sector="Other Services" if stra_sector=="Other Services";
replace stra_sector="Rest of Universe" if stra_sector=="Residual";
replace stra_sector="Rest of Universe" if stra_sector=="Rest of Universe";
replace stra_sector="Rest of Universe" if stra_sector=="Stratum 7";

replace stra_sector="Chemicals, Plastics & Rubber" if stra_sector=="Chemicals, Plastics and Rubber";
replace stra_sector="Non-Metallic Mineral Products" if stra_sector=="Non metallic mineral products";
replace stra_sector="Wholesale & Retail" if stra_sector=="Wholesale & Retail";


*added May 8, 2012;
replace stra_sector="Machinery & Equipment & Electronics" if stra_sector==" Machinery & Equipment & Electronics";


*Updated Dec.12;
replace stra_sector="Mineral, Basic Metals, Machinery & Equipment" if stra_sector=="Minerals/Metals/Machinery & Equip. (ISIC 26-29)";
replace stra_sector="Plastics & Rubber" if stra_sector=="Plastics & rubber";
replace stra_sector="Supporting Transport Activities" if stra_sector=="Supporting Transport activities";
replace stra_sector="Textiles, Garments, Leather & Paper" if stra_sector=="Textiles, Garments, Leather & Paper ";
replace stra_sector="Minerals, Metals, Machinery & Equipment" if stra_sector=="Mineral, Basic Metals, Machinery & Equipment";

#delimit cr

/******************************************************************************************** 2. Outlier flag
********************************************************************************************/
cap drop a0_ms
g a0_ms=1 if sector_MS == "Manufacturing"
replace a0_ms=2 if sector_MS == "Services"

**************************** CATEGORIZE VARS FOR OUTLIER TESTS ******************************
local co		""
local c 		""			
local c1 		""
local c1_v0 	""
local csz 		""
****** /* stop 3a */
/*local csz1 		"d2 n3 n2a l6 n2e n7a l2 n2f n2b"
local csec		"d2_n2a d2_n2e d2_n2f d2_n2b"
local csec1		"d2 n3 l1 l2 n2a l6 n7a n2e n2f n2b"	*/
local csz1 		"d2 n3 l6 l2"
local csec1		"d2 n3 l1 l2 l6"	
local _99 		""		

#delimit;
*************************** outlier - Outlier Test on  LOG(vars) **************************;
capture program drop outlier;
program define outlier;
cap g `1'o=0;
cap g log`1'=log(`1');
qui levelsof countryx, local(levels);
foreach x of local levels{;
	qui sum log`1' if countryx==`x', det;
		if `r(N)'>0{;
			qui replace `1'o=1 if log`1'>`r(mean)'+ 3*`r(sd)' & (`1'~=.) & countryx==`x' & log`1'!=.;
			qui replace `1'o=2 if log`1'<`r(mean)'- 3*`r(sd)' & (`1'~=.) & countryx==`x';
		};
	};
end;
*************************** outlier1-  Outlier Test on  LOG(vars+1) ***********************;
capture program drop outlier1;
program define outlier1;
cap g `1'o=0;
cap g log`1'=log(`1'+1);
qui levelsof countryx, local(levels);
foreach x of local levels{;
qui sum log`1' if countryx==`x', det;
	if `r(N)'>0{;
		qui replace `1'o=1 if log`1'>`r(mean)'+ 3*`r(sd)' & (`1'~=.) & countryx==`x' & log`1'!=.;
		qui replace `1'o=2 if log`1'<`r(mean)'- 3*`r(sd)' & (`1'~=.) & countryx==`x';
	};
};
end;
*************************** outlier1_v0 -  Outlier Test on  LOG(vars+1) *******************;
capture program drop outlier1_v0;
program define outlier1_v0;
cap g log`1'=log(`1'+1);
qui levelsof countryx, local(levels);
foreach x of local levels{;
qui sum log`1' if countryx==`x', det;
	if `r(N)'>0{;
		qui replace `1'Vo=1 if log`1'>`r(mean)'+ 3*`r(sd)' & (`1'~=.) & countryx==`x' & log`1'!=.;
		qui replace `1'Vo=2 if log`1'<`r(mean)'- 3*`r(sd)' & (`1'~=.) & countryx==`x';
	};
};
end;
************************ outlier_ctysz - Outlier Test on  LOG(vars), By Country-Size *******;
capture program drop outlier_ctysz;
program define outlier_ctysz;
g `1'o_sz=0;
cap g log`1'=log(`1');
qui levelsof countryx, local(levels);
qui levelsof size, local(size);
foreach x of local levels{;
	foreach s of local size{;
		qui sum log`1' if countryx==`x' & size==`s', det;
		if `r(N)'>0{;
  			qui replace `1'o=1 if log`1'>`r(mean)'+ 3*`r(sd)' & (`1'~=.) & countryx==`x' & size==`s' & log`1'!=.;
			qui replace `1'o=2 if log`1'<`r(mean)'- 3*`r(sd)' & (`1'~=.) & countryx==`x' & size==`s';
		};
	};
  };
end;

************** outlier1_ctysz - Outlier Test on  LOG(vars+1), By Country-Size *************;
capture program drop outlier1_ctysz;
program define outlier1_ctysz;
g `1'o_sz=0;
cap g log`1'=log(`1'+1);
qui egen `1'mean = mean(log`1') if size != ., by(country size);
qui egen `1'sd = sd(log`1') if size != ., by(country size);
qui replace `1'o_sz=1 if log`1'>`1'mean+ 3*`1'sd & (`1'~=.) & log`1'!=.;
qui replace `1'o_sz=2 if log`1'<`1'mean- 3*`1'sd & (`1'~=.) & size != .;
drop `1'mean `1'sd;
end;
********************* outlier_ctysec - Outlier Test on  LOG(vars), By Country-Sector *******;
capture program drop outlier_ctysec;
program define outlier_ctysec;
g `1'o_sec=0;
cap g log`1'=log(`1');
qui levelsof countryx, local(levels);
qui levelsof a0_ms, local(a0);
foreach x of local levels{;
	foreach sec of local a0{;
		qui sum log`1' if countryx==`x' & a0_ms==`sec', det;
		if `r(N)'>0{;
  			qui replace `1'o_sec=1 if log`1'>`r(mean)'+ 3*`r(sd)' & (`1'~=.) & countryx==`x' & a0_ms==`sec' & log`1'!=.;
			qui replace `1'o_sec=2 if log`1'<`r(mean)'- 3*`r(sd)' & (`1'~=.) & countryx==`x' & a0_ms==`sec';
		};
	};
  };
end;

************** outlier1_ctysec - Outlier Test on  LOG(vars+1), By Country-Sector************;
capture program drop outlier1_ctysec;
program define outlier1_ctysec;
g `1'o_sec=0;
cap g log`1'=log(`1'+1);
qui egen `1'mean = mean(log`1') if a0_ms != ., by(country a0_ms);
qui egen `1'sd = sd(log`1') if a0_ms != ., by(country a0_ms);
qui replace `1'o_sec=1 if log`1'>`1'mean+ 3*`1'sd & (`1'~=.) & log`1'!=.;
qui replace `1'o_sec=2 if log`1'<`1'mean- 3*`1'sd & (`1'~=.) & a0_ms != .;
drop `1'mean `1'sd;
end;
*********************** pctile99 - 99th %tile Test ******************************************;
capture program drop pctile99;
program define pctile99;
g `1'_99=0;
qui levelsof countryx, local(levels);
foreach x of local levels {;
	qui sum `1' if countryx==`x', d;
	qui replace `1'_99=1 if `1'>`r(p99)' & countryx==`x' & `1'!=.;
};
end;

****************************************************************************************
****************************************************************************************
************************************* RUN TESTS ****************************************
****************************************************************************************
****************************************************************************************;

local 1: word count `c';
if `1' > 0{;
	foreach var of varlist `c'{; 
		outlier `var'; 
		local co `"`co' `var'o "';
	}; 
};


local 2: word count `c1';
if `2' > 0{;
	foreach var of varlist `c1'{; 
		outlier1 `var'; 
		local co `"`co' `var'o "';
	};
}; 

local 2b: word count `c1_v0';
if `2b'>0{;
	foreach var of varlist `c1_v0' {;
		outlier1_v0 `var';
		local co `"`co' `var'Vo "'; 
	};
};


** RUN outlier_ctysz **;
local 3: word count `csz';
if `3' > 0{;
	foreach var of varlist `csz'{; 
		outlier_ctysz `var';
		local co `"`co' `var'o_sz "'; 
	};
};

** RUN outlier1_ctysz **;
local 4: word count `csz1';
if `4' > 0{;
	foreach var of varlist `csz1'{; 
		outlier1_ctysz `var';
		local co `"`co' `var'o_sz "'; 
	};
};
** RUN outlier_ctysec **;
local 5: word count `csec';
if `5' > 0{;
	foreach var of varlist `csec'{; 
		outlier_ctysec `var';
		local co `"`co' `var'o_sec "'; 
	};
};

** RUN outlier1_ctysec **;
local 6: word count `csec1';
if `6' > 0{;
	foreach var of varlist `csec1'{; 
		outlier1_ctysec `var';
		local co `"`co' `var'o_sec "'; 
	};
};

	g sector_3=1 if sector_MS=="Manufacturing" ;
	replace sector_3=3 if sector_MS=="Services" ;
	replace sector_3=2 if stra_sector == "Retail" | stra_sector == "Retail Panel";
	
	label define sector_3 1 "Manufacturing" 2 "Retail" 3 "Other Services"; // added by Nona on February 1, 2018;
	label values sector_3 sector_3;  // added by Nona on February 1, 2018;

	#delimit cr
	
	
	tostring d1a2, gen(ISIC31code)
	merge m:1 ISIC31code using  "$global_outputs\\ISIC31_4_crosswalk_4digit" , gen(mapped) keep(1 3)

	tostring d1a2_v4, gen(d1a2_v4_str)  
	replace d1a2_v4_str = "" if d1a2_v4_str == "."

	replace ISIC4Code_2digit = substr(d1a2_v4_str,1,2) if d1a2_v4_str != "" //update isic code using non-empty d1a2_v4

	merge 1:1 idstd using "$global_outputs\\ISIC31_4_crosswalk_manual" , keep(1 3)

	replace ISIC4Code_2digit =  ISIC4Code_2digit_manual if ISIC4Code_2digit=="" & ISIC4Code_2digit_manual != ""

	drop _m ISIC31Description ISIC4Description_2digit explanation mapped ISIC4Code_2digit_manual
	destring ISIC4Code_2digit, replace
	rename ISIC4Code_2digit isic_v4	
	
	replace isic = . if (year >= 2022  & country!="Iraq2022" & country!="Madagascar2022") | country=="Timor-Leste2021" // isic --> isic3.1, so after 2022, should be isic4 --> no isic3.1
	
	erase "$global_outputs\\ISIC31_4_crosswalk_manual.dta" 
	erase "$global_outputs\\ISIC31_4_crosswalk_4digit.dta" 


********************************************************************************
********************************************************************************
***                                 DEFLATE                                  ***  
********************************************************************************
********************************************************************************

	/*   Fix fiscal year for three BEEPS countries  Sep.15.2015 Xie   */
	merge 1:1 idstd using "$global_inputs_replication\BEEPS_FY_11_and_12.dta", keepus(fy fy_n3) keep(1 3)
	replace d2_l1_last_year=fy if country=="Czechia2013"|country=="Slovak Republic2013"|country=="Turkiye2013" //changed from Czech to Czech Republic by Andrea on 3/18/2020 and to Czechia by Nona on 7/26/2023
	replace n3_l2_last_year=fy_n3 if country=="Czechia2013"|country=="Slovak Republic2013"|country=="Turkiye2013" //changed from Czech to Czech Republic by Andrea on 3/18/2020  and to Czechia by Nona on 7/26/2023
	drop fy fy_n3 _m
	
	replace d2_l1_last_year = fyyeare if fyyeare != .  //Zimbabwe 2016
	replace n3_l2_last_year = fyyeare - 2 if fyyeare != . //Zimbabwe 2016
	
	replace d2_l1_last_year = 2014 if Bhbfyear != .  //Bhutan 2015
	replace n3_l2_last_year = d2_l1_last_year - 2 if Bhbfyear != . //Bhutan 2015

	replace d2_l1_last_year = a20y if a20y != .
	replace n3_l2_last_year = d2_l1_last_year - 2 if a20y != .

	merge m:1 wbcode d2_l1_last_year n3_l2_last_year using "$global_outputs\\deflation.dta", keep(1 3)
	drop _merge
	replace unitconverter = 1 if unitconverter == .
	***erase "$global_outputs\\deflation.dta" Ziqiao

	replace d2_n3_last_month = a20m if a20m != . 
	replace d2_n3_last_month = cfymth if cfymth != . //Antiguaandbarbuda2010 Bahamas2010 Barbados2010 Belize2010 Dominica2010 Dominican Republic2010 Grenada2010 Guyana2010 Jamaica2010 Stkittsandnevis2010 Stlucia2010 Stvincentandthegrenadines2010 Suriname2010 Trinidadandtobago2010
	replace d2_n3_last_month = eaa3a3w - 1 if eaa3a3w != .                // because eaa3a3w is starting month Cambodia2016 Indonesia2015 Lao PDR2016 Malaysia2015 Papua New Guinea2015 Solomon Islands2015 Thailand2016 Timor-Leste2015
	replace d2_n3_last_month = 12 if eaa3a3w != . & d2_n3_last_month == 0 // Cambodia2016 Indonesia2015 Lao PDR2016 Malaysia2015 Papua New Guinea2015 Solomon Islands2015 Thailand2016 Timor-Leste2015
	replace d2_n3_last_month = fymone if fymone != . //Zimbabwe 2016
	replace d2_n3_last_month = FYendmonth if FYendmonth != . //Bhutan 2015

	assert !(d2_l1_last_year != d2_prev_clndr_year + 1 & d2_l1_last_year != . & d2_prev_clndr_year != .)
	* if assert is wrong, last year minus one is not equal to previus year
	gen check_month = 1 if (inlist(d2_n3_last_month,1,2,3,4,5,6,7,8,9,10,11,12) | country == "Niger2006")
	assert check_month == 1
	drop check_month
	
	
	
	
	*replace exrate_n3=896.75 if country=="Myanmar2014" /* Source: IMF Myanmar country report 13250.pdf * Weighted average 2009/2010 & 2011/2012 */
                                                       /*Turned off by Andrea on 4/19/2017 because local deflators became available*/

	gen do_exrate = 1 if defl_adj_d2_last_clndr_year == . & exrate_d2_last_clndr_year*defl_adj_USA_d2_last_clndr_year != .
	replace do_exrate = 1 if (d2_n3_last_month<12 & defl_adj_d2_prev_clndr_year == .) & exrate_d2_prev_clndr_year*defl_adj_USA_d2_prev_clndr_year != .
	replace do_exrate = 1 if defl_adj_n3_last_clndr_year == . & exrate_n3_last_clndr_year*defl_adj_USA_n3_last_clndr_year != .
	replace do_exrate = 1 if (d2_n3_last_month<12 & defl_adj_n3_prev_clndr_year == .) & exrate_n3_prev_clndr_year*defl_adj_USA_n3_prev_clndr_year != .

	foreach cat in d2_last_clndr_year d2_prev_clndr_year n3_last_clndr_year n3_prev_clndr_year {
		replace defl_adj_`cat' = exrate_`cat'*defl_adj_USA_`cat' if do_exrate == 1 
		drop defl_adj_USA_`cat'
	}
	
	gen exrate_d2 = exrate_d2_last_clndr_year * d2_n3_last_month / 12 + exrate_d2_prev_clndr_year * (12 - d2_n3_last_month) / 12
	replace exrate_d2 = exrate_d2_last_clndr_year if exrate_d2 == . & d2_n3_last_month == 12 // to not require previous year's input when it is not needed
	replace exrate_d2 = 1 if exrate_d2 == . & country == "Zimbabwe2016"
	replace exrate_d2 = 1 if exrate_d2 == . & country == "United States2024" // added on April 11, 2025 by Nona
	gen exrate_n3 = exrate_n3_last_clndr_year * d2_n3_last_month / 12 + exrate_n3_prev_clndr_year * (12 - d2_n3_last_month) / 12
	replace exrate_n3 = exrate_n3_last_clndr_year if exrate_n3 == . & d2_n3_last_month == 12 // to not require previous year's input when it is not needed
	replace exrate_n3 = 1 if exrate_n3 == . & country == "Zimbabwe2016"
	replace exrate_n3 = 1 if exrate_n3 == . & country == "United States2024" // added on April 11, 2025 by Nona
	drop do_exrate exrate_d2_prev_clndr_year exrate_n3_prev_clndr_year exrate_d2_last_clndr_year exrate_n3_last_clndr_year
	  
	gen deflator_adjust_d2 = defl_adj_d2_last_clndr_year * d2_n3_last_month / 12 + defl_adj_d2_prev_clndr_year * (12 - d2_n3_last_month) / 12
	gen deflator_adjust_n3 = defl_adj_n3_last_clndr_year * d2_n3_last_month / 12 + defl_adj_n3_prev_clndr_year * (12 - d2_n3_last_month) / 12
	drop defl_adj_d2_last_clndr_year defl_adj_d2_prev_clndr_year d2_prev_clndr_year n3_prev_clndr_year defl_adj_n3_last_clndr_year defl_adj_n3_prev_clndr_year
										
	*Label variables for clarity
	label var deflator_adjust_d2 "Deflator using the fiscal year correspding to d2"
	label var exrate_d2 "exchange rate from LCU to USD for the year corresponding to d2"
	label var deflator_adjust_n3 "Deflator using the fiscal year correspding to n3"
	label var exrate_n3 "exchange rate from LCU to USD for the year corresponding to n3"
	
	*NOTE no N7 for Liberia
	foreach Z of var d2  n2* {
	gen `Z'_gdp09 = (`Z'/deflator_adjust_d2)
	}

	foreach Z of var  n3 {
	gen `Z'_gdp09 = (`Z'/deflator_adjust_n3)
	}
	
	gen nyears=d2_l1_last_year-n3_l2_last_year

	rename d2_n3_last_month d2_n3_last_month_fy_perf_ind
	rename n3_l2_last_year n3_l2_year_perf_indicators    // added by Nona on August 24, 2016, modified on April 12, 2017
	rename d2_l1_last_year d2_l1_year_perf_indicators    // added by Nona on August 24, 2016, modified on April 12, 2017
										
********************************************************************************
********************************************************************************
***                      DEFLATION COMPLETE!!!!                              ***  
********************************************************************************
********************************************************************************


**** Ziqiao: some indicator generation moved to step 4

****************************************************************************************************************************************************************************************;
* Variable preparations for indicators added on June 26, 2024, by Nona, in consultation with Jorge, Josh, Arvind, David, and Gemechu. These indicators include those used in B-READY 1  ;
* Ziqiao: need to go after generating *_gdp09
****************************************************************************************************************************************************************************************;

# delimit cr

*** the portion below is from the dofile prepared by Nona for the WBES component fo B-READY

** Handle follow-up survey variables and weights
		foreach var in o1 o2 o3a o3b n2a2 c37 {
			replace `var' = `var'_BR if inlist(a1,18,81,100,107,128)
			gen wmedian_`var' = wmedian
			replace wmedian_`var' = wmedian_BR if inlist(a1,18,81,100,107,128)
			replace wmedian_`var' = . if a1 == 100 & q_version == 2 // turning off irrelevant weights for Indonesia
		}
		foreach var in n2a {
			replace `var' = `var'_BR if inlist(a1,18,128)
			gen wmedian_`var' = wmedian
			replace wmedian_`var' = wmedian_BR if inlist(a1,18,128)
		}
		
		foreach var in j35a j35b j36 j37 c39 {
			replace `var' = `var'_BR if inlist(a1,18,81,107,128)
			gen wmedian_`var' = wmedian
			replace wmedian_`var' = wmedian_BR if inlist(a1,18,81,107,128)
		}
		
		foreach var in ge3 ge7 ge8d {
			replace `var' = `var'_BR if inlist(a1,18,81,100,128) 
			gen wmedian_`var' = wmedian
			replace wmedian_`var' = wmedian_BR if inlist(a1,18,81,100,128)
			replace wmedian_`var' = . if a1 == 100 & q_version == 1 // turning off irrelevant weights for Indonesia
		}

		foreach var in c42 d32 d33a d33b d34 d35 d39 d40a d40b d41 e31a e31b e32 e33 j31 j42 j43 k32 k33 k35 k36 k37 k38 k40 l35 l36 l37 l38 l40 l41 n11 n12 g32 {
			replace `var' = `var'_BR if inlist(a1,7,18,81,100,107,128)
			gen wmedian_`var' = wmedian
			replace wmedian_`var' = wmedian_BR if inlist(a1,7,18,81,100,107,128)
			replace wmedian_`var' = . if a1 == 100 & q_version == 2 // turning off irrelevant weights for Indonesia	
		}
		 
		foreach var in j38 j39 j40 {
			replace `var' = `var'_BR if inlist(a1,7,18,81,100,128)
			gen wmedian_`var' = wmedian
			replace wmedian_`var' = wmedian_BR if inlist(a1,7,18,81,100,128)
			replace wmedian_`var' = . if a1 == 100 & q_version == 2 // turning off irrelevant weights for Indonesia	
		}
		 
* 		replace e6_BR = e6 if inlist(a1,18,128) & year>=2021 & e6_BR == . & wmedian_BR != . // this question was not re-asked to the manufacturing firms during the follow-up

		replace c152_BR = c15_BR if inlist(a1,18,128) & c152_BR == . & wmedian_BR != . // this question was implemented somewhat differently in Bangladesh and Iraq
		replace c152 = c15 if inlist(a1,100) // this question was implemented under a different variable name in Indonesia
		replace c152 = c15 if c15 != . & a1 == 90 // Pakistan had this implemented in two parts, manuf and others separately
		
* 		removed e6
		foreach var in c152 c32 c34 c34b j33 j41 k162 k82 e1 e2b n2l n2k  {
			replace `var' = `var'_BR if inlist(a1,7,18,81,107,128) & year>=2021 
			gen wmedian_`var' = wmedian
			replace wmedian_`var' = wmedian_BR if inlist(a1,7,18,81,107,128) & year>=2021
		}
		replace c152 = c15_ESBR if c152 == . & wmedian_BR !=. & inlist(a1,81,107) // this question was implemented differently in Madagascar and Timor-Leste
				
*		removed e6
		foreach var in e2b {
			replace `var' = `var'_ESBR if inlist(a1,81,107) & year>=2021 // applicable for Madagascar and Timor-Leste only
		}	

** data transformation for compatibility across WBES questionnaire 
	replace k36 = 0 if inlist(k36,-5,-6) // added by Nona on September 25, 2025 in consultation with Cyriane, to handle the round-3 version of the WBES questionnaire consistency with the previous rounds
	replace k40 = 0 if inlist(k40,-5,-6) // added by Nona on September 25, 2025 in consultation with Cyriane, to handle the round-3 version of the WBES questionnaire consistency with the previous rounds
	
	replace d35 = . if d352 != . // this and the next line added on October 13, 2025, in consulation with Jorge and David, to ensure consistency of sector coverage across countries, as this edit was introduced in the 2025 questionnaire, this line removes mapping impelemted in the new-comprehensive
	replace d352 = . if d1a1a == 2 // added by Nona on October 13, 2025, in consulation with Jorge and David, to ensure consistency of sector coverage across countries, as this edit was introduced in the 2025 questionnaire
	replace d35 = d352 if d352 != . & d35 == . // added by Nona on September 25, 2025 in consultation with Nuno, to handle the round-3 version of the WBES questionnaire consistency with the previous rounds
	
** Some data cleaning
	replace l36 = -9 if l36 != . & l36 > 300   // removing extreme values
	replace l36_BR = -9 if l36_BR != . & l36_BR > 300 // removing extreme values
	
	replace o3a = -7 if a1 == 86 & inlist(o1,2,-9) // adding the filter that wasn't implemented during the survey
	replace o3b = -7 if a1 == 86 & inlist(o1,2,-9) // adding the filter that wasn't implemented during the survey
		
	clonevar temp_e1 = e1
	replace e1 = -9 if e2b == -4 & e1 == . // affecting Madagascar and Timor-Leste, 60 observations total
	replace e2b = . if e2b == -4 & e1 == -9 &  temp_e1 != e1 // affecting Madagascar and Timor-Leste, 60 observations total
	drop temp_e1
	
	replace n2a2 =-9 if n2a2>n2a & n2a2!=. & n2a!=. & n2a2>=0 & n2a >=0 // removing extreme values
	
	foreach var in n2a n2b n2l n2k g33 k31 c31 c38 c33 {
		replace `var' = -9 if `var'== 0
	}
	
	replace j40 = . if j38 == 1 // fixing Tanzania 46 observations where questions were asked while they were not applicable
	
	replace d40b = -9 if d40b == . & d40a == 0 // 4 observations, 1 in El Salvador, 3 in Slovak Republic
	replace d40b = . if d40b == -9 & d40a > 0 & d40a != .  // 2 observation in El Salvador, added by Nona on May 22, 2025
		
	replace k35 = -9 if k35 > 30 & k35 != . // this and the next two lines added after consulting with Kamal, Subika, Suzy
	replace k36 = -9 if k36 > 50 & k36 != .
	replace k40 = -9 if k40 > 50 & k40 != .
		
		
	** Create ratios (to feed into outlier routine)
	# delimit ;
		gen n2a2_n2a=n2a2/n2a*100 if n2a2>=0&n2a>=0; replace n2a2_n2a=-9 if (n2a2<0|n2a<0)&(n2a2!=.&n2a!=.);
		
** handle combinations that go into the outlier checks ;
		clonevar d33a_d33b_days = d33a if d33a>=0; replace d33a_d33b_days = d33a_d33b_days + d33b/24 if d33b >= 0 & d33b !=.;
		replace d33a_d33b_days = 0.5 if d33a_d33b_days == 0 & d33a == 0 & d33b ==-9 ;  // edited by Nona to replace missing to 0.5 on September 9, 2025 per discussions with Nuno, Jorge and Norman; added by Nona on May 22, 2025, handles cases when d33b is don't know which inadvertently counted as 0 instead of missing ; 

		replace d33a_d33b_days =                  d4a + d4b/24 if d42==2 & d4a>=0 & d4b>=0; // added by Nona on Sept. 3, 2025, handles 2025 questionnaire ;
		replace d33a_d33b_days = d43a + d43b/24 + d4a + d4b/24 if d42==1 & d4a>=0 & d4b>=0 & d43a>=0 & d43b>=0;
		
		clonevar d40a_d40b = d40a; replace d40a_d40b = d40a_d40b + d40b/24 if d40b >= 0 & d40b !=. & d40a == 0; replace d40a_d40b = 0.5 if d40a == 0 & d40b == -9; // edited by Nona to replace missing to 0.5 on September 9, 2025 per discussions with Jorge; 

		replace d40a_d40b =                  d14a + d14b/24 if d44==2 & d14a>=0 & d14b>=0; // added by Nona on Sept. 3, 2025, handles 2025 questionnaire ;
		replace d40a_d40b = d45a + d45b/24 + d14a + d14b/24 if d44==1 & d14a>=0 & d14b>=0 & d45a>=0 & d45b>0;			
		
		clonevar j35a_j35b = j35a; replace j35a_j35b = j35b * 12 if j35a == . & j35b >= 0 & j35b !=.; replace j35a_j35b = -9 if j35a == . & j35b == -9;
		replace j35a_j35b = j35 if j35 >= 0 & j35 !=. ; // added by Nona on October 31, 2024
	
		replace l38=1 if l38a == 0 & l38b==-9; // edited by Nona to replace missing to 1 on September 9, 2025 per discussions with Nuno, Jorge and Norman; 
	
** added by Nona on May 22, 2025, after discussion with David and Jorge, creating equivalent of d33* with d4* ; 
		egen ct_d4a = count(d4a), by(country) ;
		egen ct_d4b = count(d4b), by(country)  ;
		clonevar d4a_d4b_days = d4 if ct_d4a == 0 & ct_d4b == 0 ; drop ct_d4a ct_d4b ; // these are surveys without d4a and d4b ;
		replace d4a_d4b_days = d4a if d4a_d4b_days == . & d4a>=0; replace d4a_d4b_days = d4a_d4b_days + d4b/24 if d4b >= 0 & d4b !=.;
		replace d4a_d4b_days = 0.5 if d4a_d4b_days == 0 & d4a == 0 & d4b ==-9 ; // edited by Nona to replace missing to 0.5 on September 9, 2025 per discussions with Nuno, Jorge and Norman ;

		clonevar temp_d4a_d4b_days = d4a_d4b_days if d4a_d4b_days>=0;
		clonevar temp_d33a_d33b_days = d33a_d33b_days if d33a_d33b_days>=0;
		replace d4 = . if (temp_d4a_d4b_days - temp_d33a_d33b_days) > 0.01 & temp_d33a_d33b_days != . & temp_d4a_d4b_days  != .  & (d4a != 0 | d33a != 0);	// this is to preserve backward compatibility of 1 counting anything equaling 1 or below ;
		replace d4 = . if (d4 > 1 & d4 != . & d33a == 0 & d33b ==-9);	// this is to preserve backward compatibility of 1 counting anything equaling 1 or below ;
		replace d4 = 1 if d4 == . & d4a == 0 & d4b == -9 ; // edited by Nona on September 9, 2025 to preserve backward compatibility of 1 counting anything equaling 1 or below ;
		foreach var in d4a_d4b_days d4a d4b d33a_d33b_days d33a d33b { ;
			replace `var' = . if (temp_d4a_d4b_days - temp_d33a_d33b_days) > 0.01 & temp_d33a_d33b_days != . & temp_d4a_d4b_days  != .  ;
		} ;
		drop temp_d4a_d4b_days temp_d4a_d4b_days;

		egen ct_d14a = count(d14a), by(country) ;
		egen ct_d14b = count(d14b), by(country)  ;
		clonevar d14a_d14b_days = d14 if ct_d14a == 0 & ct_d14b == 0 ; drop ct_d14a ct_d14b ; // these are surveys without d14a and d14b ;
		replace d14a_d14b_days = d14a if d14a_d14b_days == . & d14a>=0; replace d14a_d14b_days = d14a_d14b_days + d14b/24 if d14b >= 0 & d14b !=.;
		replace d14a_d14b_days = 0.5 if d14a_d14b_days == 0 & d14a == 0 & d14b ==-9 ; // edited by Nona to replace missing to 0.5 on September 9, 2025 per discussions with Nuno, Jorge and Norman ;
		
		clonevar temp_d14a_d14b_days = d14a_d14b_days if d14a_d14b_days>=0;
		clonevar temp_d40a_d40b = d40a_d40b if d40a_d40b >=0 ;
		replace d14 = . if (temp_d14a_d14b_days - temp_d40a_d40b) > 0.01 & temp_d40a_d40b != . & temp_d14a_d14b_days  != .  & (d14a != 0 | d40a != 0);	// this is to preserve backward compatibility of 1 counting anything equaling 1 or below ;
		replace d14 = . if (d14 > 1 & d14 != . & d40a == 0 & d40b ==-9);	// this is to preserve backward compatibility of 1 counting anything equaling 1 or below ;
		replace d14 = 1 if d14 == . & d14a == 0 & d14b == -9 ; // edited by Nona on September 9, 2025 to preserve backward compatibility of 1 counting anything equaling 1 or below ;

		foreach var in d14a_d14b_days d14a d14b d40a_d40b d40a d40b { ;
			replace `var' = . if (temp_d14a_d14b_days - temp_d40a_d40b) > 0.01 & temp_d40a_d40b != . & temp_d14a_d14b_days  != .  ;
		} ;

		drop temp_d14a_d14b_days temp_d40a_d40b;

** handle weights ;
	rename wmedian_j31 wt_6_followups  ; // a1: 7,18,81,100,107,128  : 26,793 ; 
	rename wmedian_j40 wt_5a_followups ; // a1: 7,18,81,100,128      : 26,865 ; 
	rename wmedian_e2b wt_5b_followups ; // a1: 7,18,81,107,128      : 28,305 ; 
	rename wmedian_o3a wt_5c_followups ; // a1: 18,81,100,107,128    : 26,950 ; 
	rename wmedian_j35a wt_4a_followups ; // a1: 18,81,107,128        : 28,462 ; 
	rename wmedian_ge3 wt_4b_followups ; // a1: 18,81,100,128         ; 
	
	foreach var in wt_6_followups wt_5a_followups wt_5b_followups wt_5c_followups wt_4a_followups wt_4b_followups {;
		egen temp_ = max(`var'), by(country);
		replace `var' = wt if temp_ == . ; // for non-follow up surveys, replaces original weights;
		drop temp_;
	}	;
****************************************************************************************************************************************************************************************;
* End of variable preparations for indicators added on June 26, 2024, by Nona, in consultation with Jorge, Josh, Arvind, David, and Gemechu. These indicators include those used in B-READY 1  ;
****************************************************************************************************************************************************************************************;

drop a14* a15*;
*-------------------------------------------------------------;
gen logd2_gdp09=log(d2_gdp09);
gen logn3_gdp09=log(n3_gdp09);
gen lsaleg1=100*(log(d2)-log(n3))/nyears;
gen lsaleg1_r09=100*(log(d2_gdp09)-log(n3_gdp09))/nyears;
gen lsaleg1_r09_halt_raw=100*(d2_gdp09-n3_gdp09)/((d2_gdp09+n3_gdp09)/2)/nyears;

gen empgrowth_halt_raw=100*(l1-l2)/((l2+l1)/2)/nyears;

gen laborprody_t_09_raw=log(d2_gdp09/l1);
gen lpg_halt_raw=100*((d2_gdp09/l1)-(n3_gdp09/l2))/(((d2_gdp09/l1)+(n3_gdp09/l2))/2)/nyears;
gen lpg_logdiff=100*(log(d2_gdp09/l1)-log(n3_gdp09/l2))/nyears;

*************** END FLAG 2 ***************;

*** FLAG 2: sector country, ratio vars ***;
gen empgrowth_halt=empgrowth_halt_raw if l1o_sec==0 & l2o_sec==0;		
gen lsaleg1_r09_halt=lsaleg1_r09_halt_raw if d2o_sec==0 & n3o_sec==0;
gen lpg_halt=lpg_halt_raw if  d2o_sec==0 & n3o_sec==0 & l1o_sec==0 & l2o_sec==0; 
gen laborprody_t_09=laborprody_t_09_raw if d2o_sec==0  & l1o_sec==0;		 

*Indicators (basic growth rates);
gen perf1_raw=lsaleg1_r09_halt_raw;
gen perf2_raw=empgrowth_halt_raw;
gen perf3_raw=lpg_halt_raw;

gen perf1=lsaleg1_r09_halt;

gen perf2=empgrowth_halt;
gen perf3=lpg_halt;

replace perf1 = . if country == "Zimbabwe2011" ; // added by Nona on Feb. 4, 2020, as per Gemechu's request, due to hyperinflation;
replace perf3 = . if country == "Zimbabwe2011" ; // added by Nona on Feb. 4, 2020, as per Gemechu's request, due to hyperinflation;

gen perf4=100 if k4==1;replace perf4=0 if k4==2;

*** TEST ON INTERSITY OF INVESTMENT INDICATOR ***;
gen perf5=(n5a+n5b)/d2 if n5a~=.&n5b~=.; replace perf5=n5a/d2 if n5b==.; replace perf5=n5b/d2 if n5a==.;replace perf5=0 if k4==2;
gen perf5a=n5a/d2;replace perf5a=0 if k4==2;
gen perf5b=n5b/d2;replace perf5b=0 if k4==2;

gen perf5_c=(n5a+n5b)/d2 if n5a~=.&n5b~=.; replace perf5_c=n5a/d2 if n5b==.; replace perf5_c=n5b/d2 if n5a==.;replace perf5_c=. if k4==2;
gen perf5a_c=n5a/d2;replace perf5a_c=. if k4==2;
gen perf5b_c=n5b/d2;replace perf5b_c=. if k4==2;



*************************************************************************************************************************;
********* create corr2 before outlier analysis as outlier code wipes out .a (which is -8) Asif and Xie 4-23-2014*********;
*************************************************************************************************************************;
#delimit ;
gen  corr2=100 if j6>0&j6!=. | j6==.a;replace corr2=0 if j6==0; replace corr2=. if j6a==2 | j6a ==.b ;

for var j11 j14 g3 : replace X=. if X>730;

gen  car1=year-b5;   
replace car1=. if car1<0;

**	Outlier program	**;
encode country, gen(a1x); /*added by Minh 18 Nov 2010 */
** to make sure that there are no existing variables with prefix "log", I changed from "log" to "_log" **; /*added by Minh 18 Nov 2010 */

capture program drop transformation;
program define transformation;
      gen _log`1'=log(`1'+1);
end;

capture program drop outlier;
program define outlier;
	g `1'o=0;
	egen `1'mean = mean(`1'), by(country);
	egen `1'sd = sd(`1'), by(country);
	qui replace `1'o=1 if `1'<`1'mean-3*`1'sd ;
	qui replace `1'o=2 if `1'>`1'mean+3*`1'sd & (`1'~=.);
	drop `1'mean `1'sd;
end;


*************Outlier program for just the right tail of distribution AI-11-20-2013;
capture program drop outlier_2;
program define outlier_2;
	g `1'o=0;
	egen `1'mean = mean(`1'), by(country);
	egen `1'sd = sd(`1'), by(country);
	*qui replace `1'o=1 if `1'<`1'mean-3*`1'sd ;
	qui replace `1'o=2 if `1'>`1'mean+3*`1'sd & (`1'~=.);
	drop `1'mean `1'sd;
end;

**	Outlier analysis	**;
local a j4 car1 j11 j14 g3 i2b i4b l5a l5b k15 c4 c7 c13 c16 c20 d4 d14 l2 l4a l4b l3a l3b l6 l1 c9a c8 d2 k32 k33 k35 k36 k38 k40 d33a_d33b_days d34 d40a_d40b d41 l35 l36 l38 n2a2_n2a j43 j35a_j35b j33 j39 n11 c37 e31b e2b; 
/**car1 "age" added March 1 2011, josh wimpey; c9b removed by Nona on May 10, 2024 to put combination and not components into outliers, at the same time c8 was added which is a combination of c8a and c8b **/;
/** variables k32 onwards added on June 26, 2024 by Nona **/;

foreach var of varlist `a'{;
	transformation `var';
	};


foreach var of varlist _log* {;
	outlier `var' ;
	};

*foreach var of varlist `a' {;
*			tab2 a1x `var'o log`var'o ;
*	};


foreach var of varlist `a'{;
	replace `var'=. if _log`var'o==1 | _log`var'o==2;
	};

***Outlier program for just the right tail of distribution change AI-11-20-2013;

	local b j2 j6 i2a i4a c11; /* c9a removed removed by Nona to put through log-transformed outlier check with combination with c9b */;

foreach var of varlist `b'{;
	outlier_2 `var' ;
	};
	
*foreach var of varlist `b'{;
*	outlier `var' ;
*	};

foreach var of varlist `b' {;
			tab2 country `var'o;
	};

foreach var of varlist `b'{;
	replace `var'=. if `var'o==1 |`var'o==2;
	};

** added by Nona on June 26, 2024, handle combinations using a variable from the outlier routine;
	clonevar e31a_e31b = e31a if inlist(e1,1,2); replace e31a_e31b = 1 if e31a==. & (e31b>90&e31b<=100)& inlist(e1,1,2); 	replace e31a_e31b = 2 if e31a==. & (e31b>=50&e31b<=90)& inlist(e1,1,2); 	replace e31a_e31b = 3 if e31a==. & (e31b<50&e31b>=0)& inlist(e1,1,2); replace e31a_e31b = -9 if e31a==. & (e31b == -9|e31b==.) & inlist(e1,1,2);

**	Generate Indicators with -8	**;

gen  corr4=100 if (j7a>0 & j7a~=.) | (j7b>0 & j7b~=.) | (j7a==.a | j7b==.a);egen tsu=rowtotal(j7a j7b), missing;replace corr4=0 if tsu==0;  replace corr4=. if  j7a==.&j7b==.;  /** | j7b==-8 added 9/7/2010 by Josh Wimpey, changed to .a by Minh dec 2010 **/;
gen  corr1=100 if j5==1 | j5==.a;replace corr1=0 if j5==2;

gen  corr5=100 if c21==1| c21==.a;replace corr5=0 if c21==2;
gen  corr6=100 if c5==1|c5==.a;replace corr6=0 if c5==2;
gen  corr7=100 if c14==1|c14==.a;replace corr7=0 if c14==2;
gen  corr8=100 if g4==1|g4==.a;replace corr8=0 if g4==2;
gen  corr9=100 if j12==1|j12==.a;replace corr9=0 if j12==2;
gen  corr10=100 if j15==1|j15==.a;replace corr10=0 if j15==2;


** adding graft index  by(country) changed to by(idstd) jan 20 2010 joshW** ;
gen tgraft=0 if c21==2;
replace tgraft=1 if c21==1 | c21==.a;      
gen egraft=0 if c5==2;
replace egraft=1 if c5==1 | c5==.a; 
gen wgraft=0 if c14==2;
replace wgraft=1 if c14==1 | c14==.a; 
gen cgraft=0 if g4==2;
replace cgraft=1 if g4==1 | g4==.a; 
gen igraft=0 if j12==2;
replace igraft=1 if j12==1 | j12==.a; 
gen ograft=0 if j15==2;
replace ograft=1 if j15==1 | j15==.a; 
gen jgraft=0 if j5==2;
replace jgraft=1 if j5==1 | j5==.a; 
egen _t1 = total(tgraft), missing by(idstd); 
egen _t2 = total(egraft), missing by(idstd); 
egen _t3 = total(wgraft), missing by(idstd); 
egen _t4 = total(cgraft), missing by(idstd); 
egen _t5 = total(igraft), missing by(idstd); 
egen _t6 = total(ograft), missing by(idstd);
egen _t7 = total(jgraft), missing by(idstd);
egen _c1 = count(tgraft), by(idstd); 
egen _c2 = count(egraft), by(idstd); 
egen _c3 = count(wgraft), by(idstd); 
egen _c4 = count(cgraft), by(idstd); 
egen _c5 = count(igraft), by(idstd); 
egen _c6 = count(ograft), by(idstd);
egen _c7 = count(jgraft), by(idstd);
egen gift = rowtotal(_t1 _t2 _t3 _t4 _t5 _t6), missing; 
egen cgift = rowtotal(_c1 _c2 _c3 _c4 _c5 _c6), missing; 
gen graft1 = (gift/cgift)*100;
egen gift1b = rowtotal(_t2 _t3 _t4 _t5 _t6), missing; 
egen cgift1b = rowtotal(_c2 _c3 _c4 _c5 _c6), missing; 
gen graft1b = (gift1b/cgift1b)*100;
egen gift2 = rowtotal(_t2 _t3 _t4 _t5 _t6 _t7), missing; 
egen cgift2 = rowtotal(_c2 _c3 _c4 _c5 _c6 _c7), missing; 
gen graft2 = (gift2/cgift2)*100;
egen graftsum = rowtotal(tgraft egraft wgraft cgraft igraft ograft), missing;
** graftsum graftsum2 tgraft egraft wgraft cgraft igraft ograft  jgraft;
drop  _t1 _t2 _t3 _t4 _t5 _t6 _t7 _c1 _c2 _c3 _c4 _c5 _c6 _c7 gift cgift gift2 cgift2;

gen graft3=.;
replace graft3=100 if graft2>0 & graft2!=.;
replace graft3=0 if graft2==0;  /** Command added by Josh W April 3 2012---creates binary variable for graft ****/;

** end of graft ** ;


**	Eliminate -8	**;
for var j7a j7b j6 j6a j12 j15 c21 c14 c5 g4: replace X=. if X==.a; /*added by Minh 7 Dec 2010 */
